#include "mbed.h"
#include <string.h>
#include "UART_Radar.h"
#include "buzzer.h"

#define TRIG_1  PA_8
#define ECHO_1  PC_7


//DigitalOut buzz(PB_8);
DigitalOut trig(TRIG_1);

Ticker mesure_time;
Ticker send_time;
Timer distance_time;
InterruptIn echo(ECHO_1);

Buzzer buzzo;
Ticker bip;

char trame[50];
int essai, err;
int distance, distance_brut;  
char message[4];
int i=0;


//Envoie un burst
void send_burst(){ 
    distance_time.reset(); 
    trig = 0;
    wait_us(2);
    trig = 1;
    wait_us(10);
    trig = 0;
}


int max (int a, int b) {
  return (a<b)?b:a;
}

int min (int a, int b) {
  return (a<b)?a:b;
}

//Lance le timer
void echo_rise(){ 
    distance_time.start(); 
}

//Génere la trame et l'envoie à UART
void transmit_data(){
    message[0]=48+(distance/100)%10;
    message[1]=48+(distance/10)%10;
    message[2]=48+distance%10;
    message[3]=0;
        
    essai=0;
    printf("%s\n\r",message);
    send(message);
    
    err=receive(trame);
  
    while((controle(trame)==0 || err==1) && essai<3){
        send(message);
        err=receive(trame);
        essai++;
    }
}

//Stop le timer et récupére la distance en cm.
void echo_fall(){ 
    distance_time.stop(); 
    distance_brut = distance_time.read_us() /29 / 2;
    distance_brut = min(distance_brut,230);
    distance = max(distance_brut,0);
            //Mise à jour de l'intervale entre chaque bip
    buzzo.changeMode(distance);
}




int main() {
   
    echo.rise(&echo_rise);                      //Routine echo_rise sur interruption de echo en front montant.
    echo.fall(&echo_fall);                      //Routine echo_fall sur interruption de echo en front descendant.
    mesure_time.attach(&send_burst, 0.5);       //Lance send_burst toutes les 500ms.
    wait(0.1);                                  //Décalage entre send et transmit.
    send_time.attach(&transmit_data, 0.5);      //Lance transmist_data toutes les 500ms.
    wait(0.1);                                  //Décalage entre transmit et buzz.
    bip.attach_us(&buzzo, &Buzzer::run, 400);
    
    while(1);

}