#include "mbed.h"
#include <string.h>
#include "HCSR04.h"

#define TRIG_1  PA_8
#define ECHO_1  PC_7
 
Serial pc(USBTX, USBRX); //reception --- tx, rx
Serial carte(PA_9, PA_10); //emission --- tx, rx

HCSR04 sensor1(TRIG_1, ECHO_1);
DigitalOut buzz(PB_8);

int max (int a, int b) {
  return (a<b)?b:a;
}

int min (int a, int b) {
  return (a<b)?a:b;
}

void USART1_puts(char *text){
    while(*text != '\0'){
        
        if(carte.writeable()){ 
            carte.putc(*text);
            text++;
        }
        
    }
}
        

void format(char *msg, char *msg_formated){
    int somme=5;
    int i=0;
    msg_formated[0]=2;
    printf("\n\r");
    while(msg[i]!=0){
        somme= somme + msg[i];
        msg_formated[i+1]=msg[i];
        i++;
    }
    if(somme>255){
            somme++;
    }
    somme=somme%256;
    msg_formated[i+1]=~somme;
    msg_formated[i+2]=3;
    msg_formated[i+3]=0;

   //A supprimer
    i=0;
    while(msg_formated[i]!=0){
        printf("[%d] ", msg_formated[i]);
        i++;
    }
}


void send(char *data){
        char trame[52]="";
        format(data, trame);
        USART1_puts(trame);
}

int receive(char *frame){
    int I;
    unsigned int sommeBuffer;
    char r;
    Timer timeout;
    timeout.start();
    while(1){
        if(timeout.read_ms() > 100) return 1;
        if(carte.readable()){
            r = carte.getc();
            
            switch(r){
                case 2: //Start
                    I=0;
                    sommeBuffer=2;
                    break;
                    
                case 3: //Stop
                    frame[I]=0;
                    sommeBuffer+=3;
                    
                    if(sommeBuffer>255){
                        sommeBuffer++;
                    }
                    sommeBuffer=~sommeBuffer;
                    sommeBuffer=sommeBuffer%256;
                
                    if(sommeBuffer==0){ //Les sommes concordent, les données sont valides
                        frame[I-1]=0;
                        return 0;
                    }else{ //Message invalidé par la somme
                        frame[0]=0;
                        return 1;
                    }
                    
                default : 
                    frame[I]=r;
                    sommeBuffer+=r;        
                    I++;
                    break;
                }
            }
        }
}

int controle(char *frame){
    if (*frame!=6) return 0;
    else return 1;  
}

void buzz_pulse(){

}

void startEmision(){
   
}

 //Emission d'une trame, reception d'acquittement et vérification
int main() {
    char trame[50];
    int essai, error;
    int value;  
    char message[4];
    int i=0;
    Timer time;
    
    //int mem[2] = {-1, -1};
    
    while(1){
        
    time.reset();
    time.start();
    value=min(sensor1.distance(1),230);
    value=max(value,0);
        
    /*if(mem[0]<0){
        mem[0]=value;
    }else{
        if(abs(mem[0]-value)<40){
            mem[1]=mem[0];
            mem[0]=value;
        }else{
            value=mem[0];
        }
    }*/
        
        
    message[0]=48+(value/100)%10;
    message[1]=48+(value/10)%10;
    message[2]=48+value%10;
    message[3]=0;
        
    essai=0;
    printf("%s\n\r",message);
    send(message);

    error=receive(trame);
  
    while((controle(trame)==0 || error==1) && essai<3){
        send(message);
        error=receive(trame);
        essai++;
    }

    if(essai<=3) {
        while(time.read() <= 1){
            for(i =0; i<=50;i++) {
            buzz = 1;
            wait_us(400);
            buzz = 0;
            wait_us(400);  
            }
            wait_ms(value*5);
        }
        time.stop();
    }
    }
}