#include "mbed.h"
#include <string.h>
#include "HCSR04.h"
#include "buzzer.h"
//#include "rtos.h"

#define TRIG_1  PA_8
#define ECHO_1  PC_7
 
Serial pc(USBTX, USBRX); //reception --- tx, rx
Serial carte(PA_9, PA_10); //emission --- tx, rx

HCSR04 sensor1(TRIG_1, ECHO_1);
DigitalOut led1(LED1);

int max (int a, int b) {
  return (a<b)?b:a;
}

int min (int a, int b) {
  return (a<b)?a:b;
}

void USART1_puts(char *text){
    while(*text != '\0'){
        
        if(carte.writeable()){ 
            carte.putc(*text);
            text++;
        }
        
    }
}
        

void format(char *msg, char *msg_formated){
    int somme=5;
    int i=0;
    msg_formated[0]=2;
    printf("\n\r");
    while(msg[i]!=0){
        somme= somme + msg[i];
        msg_formated[i+1]=msg[i];
        i++;
    }
    if(somme>255){
            somme++;
    }
    somme=somme%256;
    msg_formated[i+1]=~somme;
    msg_formated[i+2]=3;
    msg_formated[i+3]=0;

   //A supprimer
    i=0;
    while(msg_formated[i]!=0){
        printf("[%d] ", msg_formated[i]);
        i++;
    }
}

/*
void format(char *msg, char *msg_formated){
    char *STX = 2;
    char *ETX = 3;
    strcat(msg_formated, STX);
    strcat(msg_formated, msg);
    strcat(msg_formated, ETX);
}
*/

void send(char *data){
        char trame[52]="";
        format(data, trame);
        USART1_puts(trame);
}

/*
void receive(char *frame){
    char trame[50]={0};
    int etat = 0;
    while(etat != 2){
        char r;
        if(carte.readable()){
            r = carte.getc();
            switch(etat){
                case 0 :    if(r == 'S'){etat = 1;}
                                    break;
                case 1 :    if(r != 'E'){strcat(trame,&r);}
                            else { etat = 2; }
                            break;
                default :   break;
                }
        }
    }
    for(int i=0;i<50;i++){
        frame[i]=trame[i];
    }
}
*/

int receive(char *frame){
    int end = 0;
    int I;
    unsigned int sommeBuffer;
    char r;
    Timer timeout;
    timeout.start();
    while(1){
        if(timeout.read_ms() > 100) return 1;
        if(carte.readable()){
            r = carte.getc();
            
            switch(r){
                case 2: //Start
                    I=0;
                    sommeBuffer=2;
                    break;
                    
                case 3: //Stop
                    frame[I]=0;
                    sommeBuffer+=3;
                    
                    if(sommeBuffer>255){
                        sommeBuffer++;
                    }
                    sommeBuffer=~sommeBuffer;
                    sommeBuffer=sommeBuffer%256;
                
                    if(sommeBuffer==0){ //Les sommes concordent, les données sont valides
                        frame[I-1]=0;
                        return 0;
                    }else{ //Message invalidé par la somme
                        frame[0]=0;
                        return 1;
                    }
                    break;
                    
                default : 
                    frame[I]=r;
                    sommeBuffer+=r;        
                    I++;
                    break;
                }
            }
        }
    return 1;
}

int controle(char *frame){
    if (*frame!=6)
        return 0;
    return 1;
        
}

void tictac(){
    led1 = !led1;
}
void bipContinu(){
    led1 = 1;
}
void bipOff(){
    led1 = 0;
}

 //Emission d'une trame, reception d'acquittement et vérification
int main() {
    
    Ticker tic;
    tic.attach(&bipOff, 0.1);
    
    Buzzer buzzo;
    Ticker bip;
    bip.attach_us(&buzzo, &Buzzer::run, 100);
    
    char trame[50];
    int essai, error;
    int i=0;
    int value;  
    char message[4];
    
    int mem[2] = {-1, -1};
    int memFreq = 0;
    Timer timeout;
    
    while(1){
        
        value=min(sensor1.distance(1),230);
        value=max(value,0);
        
        /* Filtrage */
        if(mem[0]<0){
            mem[0]=value;
        }else{
            if(abs(mem[0]-value)<40){
                mem[1]=mem[0];
                mem[0]=value;
            }else{
                value=mem[0];
            }
        }
        
        //Mise à jour de l'intervale entre chaque bip
        buzzo.changeMode(value);
        
        message[0]=48+(value/100)%10;
        message[1]=48+(value/10)%10;
        message[2]=48+value%10;
        message[3]=0;
        
        essai=0;
        printf("%s\n\r",message);
        send(message);

        error=receive(trame);
 
        
        while((controle(trame)==0 || error==1) && essai<3){
            send(message);
            error=receive(trame);
            essai++;
        }
        
        if(essai==3) return 0;
        
        i=(i+1)%10;
        wait(1);
        
    }
}