//OU Configurable Robot Project
//Spring 2017
//William Bonner

#include "mbed.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"

class RobotView
{
    //The current page displayed by the robot interface
    int _page;
    //The current line for info to be display on
    int _infoline;
    //LCD Display Object
    LCD_DISCO_F469NI _lcd;
    
    //Touchscreen Variables
    TS_DISCO_F469NI _ts;
    TS_StateTypeDef TS_State;
    uint16_t ts_x, ts_y;
    
    public:
    
    //Constructors/Destructors
    ~RobotView();
    RobotView();
    
    //Accessors/Mutators
    int getPage(){return _page;}
    void setPage(int p) {_page = p; update();}
    
    //Initialize the screen to display the robot menu
    void init();
    //Write the current page to the lcd
    void update();
    //Clear the screen
    void clear();
    //Check for touches on the screen
    int listen();
    //Check which selection the user made based on the current page
    int checkSelection();
    //Display string given in parameters
    void writeString(char* c, int line);
};