//OU Configurable Robot Project
//Spring 2017
//William Bonner

#include "mbed.h"
#include "motordriver.h"


class RobotModel
{
    //Current mode of operation
    //0 = await command
    int _mode;
    
    int _larray[8];
    int _threshold;
    int _cds[2];
    
    Timer sonar_t;
    
    float speedLeft;
    float speedRight;
    
    public:
    
    //Constructors/Destructors
    ~RobotModel();
    RobotModel();
       
    //Accessors/Mutators
    int getMode() const {return _mode;}
    void setMode(int m){_mode = m;}
    
    //initialize the robot's hardware
    void init();
    //update the model based on the mode
    int update();
    
    //read the indicated light sensor
    int checkLight(int x);
    //read bit b of the line array
    int checkLine(int b);
    //scan the ADC on channel n
    int scan(int n);
    
    //Motor Methods
    void StopMotors(void);
    void TurnRight();
    void TurnLeft();
    void DriveStraight();
    void DriveSquare();
    void DriveStraightMode(int ModeSetting);
    void TurnDegrees(int Degrees,int TurnDir);
    
    float LeftSpeed();
    float RightSpeed();
};