//OU Configurable Robot Project
//Spring 2017
//William Bonner

#ifndef R_CONTROLLER
#define R_CONTROLLER
#include "RobotController.h"
#endif

//Constructors/Destructors
RobotController::~RobotController()
{
    //#TODO
}

RobotController::RobotController()
{
    setView(new RobotView());
    setModel(new RobotModel());
}

//Handles choices made by the user on the robot interface
//input: selection value
void RobotController::userSelection(int s)
{
    //no input
    if(s < 0)
        return;
        
    model->setMode(0);
    switch(view->getPage())
    {
        default:
            if(s == 0)
                view->setPage(1);
                return;
        case 0:
            return;
        case 1://Main Menu
            switch(s)
            {
                case 0:
                    view->setPage(2);
                    model->setMode(2);
                    return;
                case 1:
                    view->setPage(3);
                    model->setMode(3);
                    return;
                case 2:
                    view->setPage(4);
                    model->setMode(4);
                    return;
                case 3:
                    view->setPage(5);
                    model->setMode(5);
                    return;
                case 4:
                    view->setPage(6);
                    model->setMode(6);
                    return;
            }
            return;
        case 2://Line Follower
        case 3://Object Following
        case 4://Light Avoidance
        case 5://TV Remote Control
        case 6://Wiimote Control
            if(s==0)
                view->setPage(1);
            return;
    }
}

//Go to main menu
void RobotController::main()
{
    model->setMode(0);
    view->setPage(1);
}

//Listens for inputs
void RobotController::listen()
{
    userSelection(view->listen());
}

//Update robot state
void RobotController::update()
{
    int info = model->update();
    char buffer[50];
    switch(model->getMode())
    {
        default:
        case 0:
            break;
        case 2://Line Follower
            sprintf (buffer, "%d %d %d %d %d %d %d %d", model->checkLine(7), model->checkLine(6), model->checkLine(5)
            , model->checkLine(4), model->checkLine(3), model->checkLine(2), model->checkLine(1), model->checkLine(0)); 
            view->writeString(buffer, 14);
            sprintf(buffer, "LS %3.2f    RS %3.2f", model->LeftSpeed(), model->RightSpeed());
            view->writeString(buffer,16);
            sprintf (buffer, "%d", info);
            view->writeString(buffer,18);
            break;
        case 3://Object Following
            sprintf (buffer, "%d", info);
            view->writeString(buffer, 14);
            break;
        case 4://Light Avoidance
            sprintf (buffer, "L %d    R %d", model->checkLight(0), model->checkLight(1));  
            view->writeString(buffer, 14);
            sprintf(buffer, "LS %3.2f    RS %3.2f", model->LeftSpeed(), model->RightSpeed());
            view->writeString(buffer,16);
            break;
        case 5://TV Remote Control
            sprintf (buffer, "%d", info);  
            view->writeString(buffer, 15);
            break;
        case 6://Wiimote Control
            sprintf (buffer, "%d", info);  
            view->writeString(buffer, 15);
            userSelection(0);
            break;
    }
}