//OU Configurable Robot Project
//Spring 2017
//William Bonner

#include "RobotView.h"

//Constructors/Destructors
RobotView::~RobotView()
{
    //#TODO
}
RobotView::RobotView()
{
    _page = 0;
}

//Initialize the screen to display the robot menu
void RobotView::init()
{
    //Show splash screen
    update();
    wait(1);

    //Initialize touchscreen and display results
    uint8_t status = _ts.Init(_lcd.GetXSize(), _lcd.GetYSize());
    if (status != TS_OK) {
        _lcd.Clear(LCD_COLOR_RED);
        _lcd.SetBackColor(LCD_COLOR_RED);
        _lcd.SetTextColor(LCD_COLOR_WHITE);
        _lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        _lcd.Clear(LCD_COLOR_GREEN);
        _lcd.SetBackColor(LCD_COLOR_GREEN);
        _lcd.SetTextColor(LCD_COLOR_WHITE);
        _lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    wait(1);
}

//Write the current page to the lcd
void RobotView::update()
{
    //Clear Screen
    clear();
    _infoline=0;
    //Write current page
    switch(_page)
    {
        case 0://Welcome Screen
            _lcd.DisplayStringAt(0, LINE(7), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            break;
        case 1://Main Menu
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"Line Follower", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(8), (uint8_t *)"Object Following", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Light Avoidance", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"TV Remote Control(Drive Forward)", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(17), (uint8_t *)"Wiimote Control(Drive in Square)", CENTER_MODE);
            break;
        case 2://Line Follower
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Line Following...", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"UNDER CONSTRUCTION", CENTER_MODE);
            _infoline=14;
            break;
        case 3://Object Following
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Object Following", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"UNDER CONSTRUCTION", CENTER_MODE);
            _infoline=14;
            break;
        case 4://Light Avoidance
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Light Avoidance", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"UNDER CONSTRUCTION", CENTER_MODE);
            _infoline=14;
            break;
        case 5://TV Remote Control
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"TV Remote Control", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"UNDER CONSTRUCTION", CENTER_MODE);
            _infoline=14;
            break;
        case 6://Wiimote Control
            _lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"Configurable Robot", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"University of Oklahoma", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(11), (uint8_t *)"Wiimote Control", CENTER_MODE);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)"UNDER CONSTRUCTION", CENTER_MODE);
            _infoline=14;
            break;
        default:
            char buffer[50];
            sprintf (buffer, "%d", _page);
            _lcd.DisplayStringAt(0, LINE(14), (uint8_t *)buffer, CENTER_MODE);
            break;
    }
    
    //display back button
    if(_page > 1)
    {
        _lcd.DisplayStringAt(0, LINE(21), (uint8_t *)"<- Back", RIGHT_MODE);
    }
    
    //#TODO Display supply voltage
}

//Clear the screen
void RobotView::clear()
{
    _lcd.Clear(LCD_COLOR_WHITE);
    _lcd.SetBackColor(LCD_COLOR_WHITE);
    _lcd.SetTextColor(LCD_COLOR_BLUE);
}

//Check for touches on the screen
int RobotView::listen()
{
    _ts.GetState(&TS_State);
    if (TS_State.touchDetected)
    { 
      ts_x = TS_State.touchX[0];
      ts_y = TS_State.touchY[0];
      wait_ms(200);
      return checkSelection();
    }
    return -1;
}

//Check which selection the user made based on the current page
int RobotView::checkSelection()
{
    if(_page > 1 && ts_y <=(18))
        return -1;
    switch(_page)
    {
        case 0:
        default:
            return -1;
        case 1://Main Menu
            if(ts_y <= LINE(6))
                return 0;
            else if(ts_y <= LINE(9))
                return 1;
            else if(ts_y <= LINE(12))
                return 2;
            else if(ts_y <= LINE(15))
                return 3;
            else if(ts_y <= LINE(18))
                return 4;
            else
                return 5;
        case 2://Line Following
        case 3://Object Following
        case 4://Light Avoidance
        case 5://TV Remote Control
        case 6://Wiimote Control
            if(ts_y >= LINE(18) && ts_x >= LINE(10))
                return 0;
            
    }
    return -1;
}

//Display string given in parameters
void RobotView::writeString(char* c, int line)
{
    if(line >= 0)
        _infoline = line;
    _lcd.ClearStringLine(_infoline);
    _lcd.DisplayStringAt(0, LINE(_infoline), (uint8_t *)c, CENTER_MODE);
    _infoline++;
}