#include "mbed.h"
#include <math.h>

#define convert_rad 0.01745329252f
#define convert_deg 57.29577951f

#define START_COM 0xA5
#define SCAN 0x20
#define STOP 0x25
#define NB_BYTE 5
#define SCAN_SIZE 400 //300 suffisant

#define Kp 2.2f
#define Kd 500.0f
#define Ki 0.000001f
#define width 170.0

PwmOut pwm_lidar (PA_15);
DigitalOut led (LED3);
InterruptIn BP (USER_BUTTON);

DigitalOut mesure1 (PC_8);
DigitalOut mesure2 (PC_9);

Serial lidar(PC_10,PC_11,256000);
Serial bluetooth (PA_0, PA_1,115200);
Serial usb(USBTX,USBRX,921600);
CAN can(PA_11,PA_12,1000000);


Timer mesure;
Timer timer_pid;
void lidar_ISR(void);
void bluetooth_isr(void) ;
//void organise (void);
char direction (float error);

void bp_ISR(void);
void start_lidar (void);
void stop_lidar (void);
void stop_car (void);

unsigned short strat (void);
void send_can (unsigned short msg);
float convert_neg (float angle);

typedef struct {
    float angle [SCAN_SIZE];
    float distance [SCAN_SIZE];
    unsigned int taille;
    bool qualite[SCAN_SIZE];
} T_SCAN;

unsigned int temps;
bool lock_array = false;
bool run = false;
unsigned short temp_size = 0;
unsigned char temp_array [SCAN_SIZE][NB_BYTE]= {0};
T_SCAN scan;


int main()
{
    BP.fall(&bp_ISR);
    usb.format(8, SerialBase::None, 1);
    pwm_lidar.period_us(40);
    pwm_lidar.write(0.6f);
    lidar.attach(&lidar_ISR,Serial::RxIrq);
    bluetooth.attach(&bluetooth_isr, Serial::RxIrq);
    timer_pid.start();
    mesure.start();
    CANMessage message;

    stop_lidar();
    wait_ms(5);
    start_lidar();

    while(true) {
        
        if (lock_array) {
            
            //printf("latence %d ms \n",mesure.read_ms());
            //organise();
            if(run==true)
                send_can(strat());
            else
                stop_car();
            mesure.reset();
        }
        if(run==false)
            stop_car();
    }
}

void lidar_ISR (void)
{
    mesure1=!mesure1;
    
    static char state=0;
    static char byte[5];
    static unsigned short i=0,j=0;
    unsigned short angle;
    char descriptor[7]= {0xA5,0x5A,0x05,0x00,0x00,0x40,0x81};
    
    
    switch (state) {

        case 0:
            if(descriptor[i]==lidar.getc()) {
                i++;
                if(i==7) {
                    state=1;
                    i=0;
                }
            }
            break;


        case 1:
            byte[i]=lidar.getc();
            i++;
            if(i==5) {
                angle=(byte[2]<<8|byte[1])>>1;
                if(angle>=17920 && lock_array==false)//14464
                    state=2;
                i=0;
            }
            break;


        case 2:
            byte[i]=lidar.getc();
            i++;
            if(i==5) {

                angle=(byte[2]<<8|byte[1])>>1;

                if(angle>=17920 ||angle<=5120) { //filtre distance
                    memcpy(&temp_array[j][0],byte,NB_BYTE);
                    j++;
                } else if(angle>5120) { // ou (0x2140-...) 8512
                    lock_array=true;
                    state=1;
                    temp_size=j;
                    j=0;
                    
                }
                i=0;
            }
            break;
    }
    mesure1=!mesure1;
}
unsigned short strat (void)
{
    unsigned short max_index=125,min_tang=5, max_tang=5, i_tang;
    unsigned char speed, angle,B0;
    float error,max_distance=15.0f,dist_min,angl_comp;
    mesure2=!mesure2;
    //Stratégie de la voiture
    scan.taille=temp_size;
    
    for(int i=0; i<scan.taille; i++) {
        
        B0=temp_array[i][0];//B1=temp_array[i][1];B2=temp_array[i][2];B3=temp_array[i][3];B4=temp_array[i][4];

        scan.angle[i]=((float)(((temp_array[i][2]<<8)|temp_array[i][1])>>1))/64.0f;
        scan.distance[i]=((float)((temp_array[i][4]<<8)|temp_array[i][3]))/4.0f;

        if((B0==0x3E || B0==0x3D) && scan.distance[i]>155.0f)
            scan.qualite[i]=true;
        else
            scan.qualite[i]=false;

        if (scan.distance[i]> max_distance && scan.qualite[i]==true) {
            max_distance=scan.distance[i];
            max_index=i;
        }
        
    }

    //Angle de compensation

    if(max_index>(scan.taille-5))
        max_tang=scan.taille-max_index;
    else if (max_index < 5)
        min_tang=5-max_index;;

    i_tang=max_index;
    dist_min=max_distance;

    for (int k=max_index-min_tang; k<max_index+max_tang; k++) {
        if(scan.distance[k]<dist_min && scan.qualite[k]) {
            i_tang=k;
            dist_min=scan.distance[k];
        }
    }
    if(dist_min<max_distance-500.0f){
        angl_comp=asin(width/scan.distance[i_tang])*convert_deg;

        if (scan.angle[max_index]<180.0f)
        angl_comp=-angl_comp;
    }
    else
        angl_comp=0.0f;
    
    
    error=scan.angle[max_index]+angl_comp;
    error=convert_neg(error);
    angle=direction(error);
        
    lock_array=false;//---------------------------------------------------------
    speed=25;//25;
    
    mesure2=!mesure2;
    return (speed<<8|angle);
}

char direction (float error)
{
    //const float angular_range =28.81f; //(plage angulaire /2)
    unsigned char angle;
    float cmd_temp,P,I,D,dt_us,S_I=0,angle_tempo;
    static float I_memo[10]= {0};
    static float error_memo;

    dt_us=((float)timer_pid.read_us());

    P=Kp* error;
   /* D=Kd*(error-error_memo)/dt_us;

    for(int i=10; i>0; i--) {
        I_memo[i]=I_memo[i-1];
        S_I=S_I+I_memo[i];
    }
    I_memo[0]=((error+error_memo)/2.0f)*dt_us;
    I=Ki*(I_memo[0]+S_I);*/

   // error_memo=error;

    //cmd_temp=(P+I+D)/10.0f;
    cmd_temp=P;


    if (cmd_temp<-127.0f)
        angle=0;

    else if(cmd_temp>127.0f)
        angle=255;

    else
        angle=(unsigned char)(cmd_temp+127.0f);

    //usb.printf("%f_%f_%d\n",error,cmd_temp,angle);
    timer_pid.reset();

    return angle;
}

void send_can (unsigned short msg)
{


    CANMessage message;

    message.len=3;
    message.data[2]= 1;
    message.data[1]= msg>>8;
    message.data[0]= msg &0x00FF;
    message.id=0x300;
    message.type=CANData;
    message.format=CANStandard;

    //usb.printf("%d\n",message.data[0]);
    can.write(message);

}

void bp_ISR(void)
{
    static bool state=false;
    state=!state;

    if(state) {
        //start_lidar();
        run = 1;
    } else {
        //stop_lidar();
        run = 0;
    }
}

void start_lidar (void)
{
    usb.printf("start");
    lidar.attach(&lidar_ISR,Serial::RxIrq);//---------------------------------//
    lidar.putc(START_COM);
    lidar.putc(SCAN);
}

void stop_lidar (void)
{
    lidar.putc(START_COM);
    lidar.putc(STOP);
    usb.printf("stop");
}
void stop_car (void)
{
    CANMessage message;

    message.len=3;
    message.data[2]= 0;
    message.data[1]= 0;
    message.data[0]= 128;
    message.id=0x305;
    message.type=CANData;
    message.format=CANStandard;

    can.write(message);
}
float convert_neg (float angle)
{
    if (angle>180.0f) {
        angle=angle-360.0f;
        return angle;
    } else
        return angle;
}

void bluetooth_isr(void){
    led = !led ;
    char data = bluetooth.getc() ;
    if(data == 0xFF){
        run = 1 ;
        start_lidar();
        }
    if(data == 0xFE){
        run = 0;
        stop_lidar() ;
        }
    }