#include "mbed.h"
void set_position(unsigned short us);
void serial_ISR(void);
void print(void);
Timer tempo;
PwmOut Pulse_Servo(p23);
PwmOut PWM_Mot(p26);
Serial serial_port(USBTX, USBRX, 115200);
unsigned short pos = 1000;
float vit = 0 ;
int main()
{   tempo.start();
    serial_port.attach(&serial_ISR,Serial::RxIrq);
    //0.75 ms----1.5 ms (center)----2.25 ms
    set_position(1500);
    PWM_Mot.period_ms(20);
    while (true){
        set_position(pos);
        PWM_Mot.write(vit);
        wait_ms(50);
    }
}

void set_position(unsigned short us){
    unsigned short period= us+20000;
    float pulse_width;
    if (tempo.read_ms()> 50){
        pulse_width=((float)us)/((float)period);
        Pulse_Servo.period_us(period);
        Pulse_Servo.write(pulse_width);
        tempo.reset();
    }
}
void serial_ISR(void){
    char msg=serial_port.getc();
    switch (msg){
        case 'a':
            pos=pos+100;
            break;
        case 'z':
            if (pos>100)
                pos=pos-100;
            break;
        case 'e':
            pos=pos+10;
            break;
        case 'r':
            if (pos>10)
                pos=pos-10;
            break;
        case 'q':
            if (vit<1.0)
                vit+=0.1 ;
            break;
        case 's':
            if (vit>0.0)
                vit-= 0.1 ;
            break;
        case 'd':
            if (vit<1.0)
                vit+=0.01 ;
            break;
        case 'f':
            if (vit>0.0)
                vit-=0.01 ;
            break;
        
            
    }
    print();
}
void print (void){
    serial_port.printf("%d us\n",pos);
}