/*Charlie Bailey
 Hild Bede*/

#include "mbed.h"
#include "ADXL362.h"
/* This program fetches samples from the AXDL362 and prints the readings in various formats. */

/* Serial device declaration */
Serial pc(USBTX,USBRX); // serial tx, rx
ADXL362 adxl362(p11, p12, p13, p10);  /* Accelerometer (mosi, miso, sclk, cs) */
DigitalOut led1(LED1); /* LED1 */
DigitalOut led2(LED2); /* LED2 */
DigitalOut led3(LED3); /* LED3 */
DigitalOut led4(LED4); /* LED4 */

/* Main loop */
int main()
{

float meanx=0, meany=0, meanz=0, stddevx=0, stddevy=0, stddevz=0, sumvarx=0, sumvary=0, sumvarz=0, variancex=0, variancey=0, variancez =0;
float xval[100]; /* array to store readings */
float yval[100];
float zval[100];
int8_t xdata, ydata, zdata;
float max_valx, max_valy, max_valz, min_valx, min_valy, min_valz, sumx, sumy, sumz;
int N=10;
float T=0.1;
float L=60;
int i;
	int user_cmd; /* User command is stored in this variable */

	pc.printf("\n\nThis program analyses readings from an accelerometer.");
	
	adxl362.init_spi();/* set up SPI interface */
	adxl362.init_adxl362();/* Set up accelerometer */
	wait(0.1);/* wait 100ms for accelerometer to initialise */
	
	while(1) 
	
	{ 
		
		/* Print a simple menu */ 
		pc.printf("\nMenu for anaysing accelerometer readings\n"); 
		pc.printf("1: Take Readings\n"); 
		pc.printf("2: Display maximum and minimum values\n"); 
		pc.printf("3: Display mean values\n"); 
		pc.printf("4: Display standard deviation of values\n"); 
		pc.printf("5: Change sample rate \n"); 
		pc.printf("6: Illuminate LEDs when acceleration exceeds your chosen value \n"); 
		pc.printf("7: Exit Program\n"); 
		pc.printf("Command: "); 
		pc.scanf("%i",&user_cmd); /* Get command from PuTTY terminal */
		
		/* Process user command */ 
		switch(user_cmd) 
		{ 
			case(1):
					
				pc.printf("Chose number of readings: "); 
				pc.scanf("%i",&N); /*takes user input */
				pc.printf("Taking %i readings...\n",N);
				
				for (i=0;i<100;i=i+1) /* clears all arrays */
				{
				xval[i]=0;
				yval[i]=0;
				zval[i]=0;
				}
				{
				max_valx=-1000;
				max_valy=-1000;
				max_valz=-1000;
				min_valx=1000;
				min_valy=1000;
				min_valz=1000;
				sumx=0;
				sumy=0;
				sumz=0;
				}
				for(i=0;i<N;i=i+1)
				{ 
					{
					adxl362.ACC_GetXYZ8(&xdata, &ydata, &zdata);/* fetch readings */
					xval[i]=float(xdata); /*store x reading */
					yval[i]=float(ydata); /*store y reading */
					zval[i]=float(zdata); /*store z reading */
					
					pc.printf("Reading no. %i\t\t x= %i\t\t y= %i\t\t z= %i\n",i+1 ,xdata, ydata, zdata);/* print X-reading */
					
					if(max_valx<xval[i])max_valx=xdata;/* update x maximum if necessary */
					if(max_valy<yval[i])max_valy=ydata;/* update y maximum if necessary */						
					if(max_valz<zval[i])max_valz=zdata;/* update z maximum if necessary */
						
					if(min_valx>xval[i])min_valx=xdata;/* update x minimum if necessary */
					if(min_valy>yval[i])min_valy=ydata;/* update y minimum if necessary */
					if(min_valz>zval[i])min_valz=zdata;/* update z minimum if necessary */
					
					{
					sumx = sumx + xval[i];		/* sums all values */
					sumy = sumy + yval[i];					
					sumz = sumz + zval[i];
					}
					
					{
					meanx = sumx/N; /*calcualtes means of values*/
					meany = sumy/N;
					meanz = sumz/N;
					}
					
								
					
					wait(T);/* wait some period of time before next sample */
					
					}
				}
					
					for(i=0;i<N;i=i+1) /* sums to allow calculation of standard deviation later */
					{
					sumvarx = sumvarx + (xval[i]-meanx)*(xval[i]-meanx) ;
					sumvary = sumvary + (yval[i]-meany)*(yval[i]-meany) ; 					
					sumvarz = sumvarz + (zval[i]-meanz)*(zval[i]-meanz) ; 			
					}
				 
				
				
				break;
			case(2): 
				pc.printf("Maximum and minimum values are:\n"); /* prints maximum and minimum x and y values*/
				
				{ 
					pc.printf("Maximum x reading was %+04f\n",max_valx);/* print max x result */
					pc.printf("Maximum y reading was %+04f\n",max_valy);/* print max y result */
					pc.printf("Maximum z reading was %+04f\n",max_valz);/* print max z result */
					pc.printf("Minimum x reading was %+04f\n",min_valx);/* print min x result */
					pc.printf("Minimum y reading was %+04f\n",min_valy);/* print min y result */
					pc.printf("Minimum z reading was %+04f\n",min_valz);/* print min z result */
				} 
				break;
				
			case(3): 
				pc.printf("Mean values are:\n"); /* prints mean values */
				{ 
					pc.printf("Mean of x values was %+04f\n",meanx);/* print mean of x values */
					pc.printf("Mean of y values was %+04f\n",meany);/* print mean of y values */
					pc.printf("Mean of z values was %+04f\n",meanz);/* print mean of z values */	
				} 
				break;
			case(4): 
				pc.printf("Calculating standard deviation...\n"); /* calcuates standard deviation */
					{
					variancex = sumvarx/(N-1);
					variancey = sumvary/(N-1);
					variancez = sumvarz/(N-1);
					}
					
					{
					stddevx = sqrt( variancex );
					stddevy = sqrt( variancey );
					stddevz = sqrt( variancez );
					}
				
				{ 
				pc.printf("Standard deviation of x values: %+04f\n",stddevx);/* print mean of x values */
				pc.printf("Standard deviation of y values: %+04f\n",stddevy);/* print mean of y values */
				pc.printf("Standard deviation of z values: %+04f\n",stddevz);/* print mean of z values */			
				} 
				
				break;
				
			case(5): 
				pc.printf("Choose sample rate (readings/s), T: \n"); /*allows user to change sample rate*/
				pc.scanf("%f",&T); /*takes users input*/
				pc.printf("You chose to take one sample every %f seconds\n",T);
				break;
				
			case(6): 
				pc.printf("Chose threshold value:\n"); /*allows user to change threshold value*/
				pc.scanf("%f",&L);
				pc.printf("You chose %f as your threshold acceleration. \n",L);
				
				while (2)
				{
					adxl362.ACC_GetXYZ8(&xdata, &ydata, &zdata);/* fetch readings */
					/* Set LEDs depending upon a threshold value of acceleration */ 
					if(xdata>=L) 
					{ 
						led1=1; 
					} 
					else 
					{
					led1=0; 
					}
					if(ydata>=L) 
					{ 
						led2=1; 
					} 
					else 
					{
					led2=0; 
					}
					if(zdata>=L) 
					{ 
						led3=1; 
					} 
					else 
					{
					led3=0; 
					}
					wait(T);/* wait some period of time before next sample */
				}
				
				
				
				break;
				
			case(7): 
				
				pc.printf("Program stopping...\n"); 
				return(0); /* Return from main, ending the program */ 
				break;
				
			default: 
				pc.printf("Error, invalid command...\n"); 
		} 
	}


return(0);/* normal exit */

	}
	




