#include "mbed.h"
#include "LocalPinNames.h"
#include "BridgeDriver.h"
#include "TextLCD.h"

I2C i2c(P0_10,P0_11);       // I2C bus (SDA, SCL)
BridgeDriver bridges(&i2c); // bridge
TextLCD_I2C lcd(&i2c, MCP23008_SA0, TextLCD::LCD20x4); // LCD
DigitalIn killSw(KILL);

void setDrives(int NEWSTATE) {
    lcd.setAddress(0,3); //set cursor to 0,0
    if (NEWSTATE)
        lcd.printf("Power On   ");
    else
        lcd.printf("Power Off  ");
    bridges.drive(1,NEWSTATE);
    bridges.drive(2,NEWSTATE);
    bridges.drive(3,NEWSTATE);
    bridges.drive(4,NEWSTATE);
    bridges.drive(5,NEWSTATE);
    bridges.drive(6,NEWSTATE);
    bridges.drive(7,NEWSTATE);
    bridges.drive(8,NEWSTATE);
}

int main() {
    killSw.mode(PullUp);
    i2c.frequency(1000000);
    lcd.setBacklight(TextLCD::LightOn);
    lcd.cls(); //clear the display
    lcd.setAddress(0,0); //set cursor to 0,0
    lcd.printf("Simple Power Supply");
    lcd.setAddress(0,1);
    lcd.printf("Operate with run sw.");
    
    int currentKillState = killSw;
    setDrives(!currentKillState);
    
    while(1) {
        if (currentKillState != killSw) {
            currentKillState = killSw;
            setDrives(!currentKillState);
        }
        wait(0.1);
    }
}
