// Teensy3.1 USB Serial, RTC test

// Requires 32KHz crystal fitted.
// Unplug then plug back in the Teensy after programing to reactivate the Teensy USB serial port.
// if your terminal program can't see the Teensy

#include "mbed.h"
#include "USBSerial.h"

// include to check/display clock rates
#include "clk_freqs.h"
 
//Virtual serial port over USB
USBSerial serial;

DigitalOut led(LED1);

struct tm t;
char timebuff[80];

int minute      =20;    // 0-59
int hour        =23;    // 0-23
int dayofmonth  =30;    // 1-31
int month       =9;     // 1-12
int year        =15;    // last 2 digits
 
void setRTC()
{
            t.tm_sec = (0);             // 0-59
            t.tm_min = (minute);        // 0-59
            t.tm_hour = (hour);         // 0-23
            t.tm_mday = (dayofmonth);   // 1-31
            t.tm_mon = (month-1);       // 0-11  "0" = Jan, -1 added for Mbed RCT clock format
            t.tm_year = ((year)+100);   // year since 1900,  current year + 100 + 1900 = correct year
            set_time(mktime(&t));       // set RTC clock                
}  
 
int main(void) {
 
    led=1;
    
    //setRTC(); // If back up cell fitted, comment this out after the RTC has been set then re-program.  
    
    while(1)
    {   
        time_t seconds = time(NULL);
        strftime(timebuff,80,"\n\n Teensy RTC\r\nTime:  %H:%M:%S\r\nDate:  %A %d %B %Y\n\n", localtime(&seconds));       
        serial.printf(timebuff);       
        
        serial.printf("\n core %d",SystemCoreClock);
        
        serial.printf("\n Bus  %d",bus_frequency());
        
        serial.printf("\n Osc  %d",extosc_frequency());
        
        led=0;        
        wait(1);
        led=1;         
    }
}
