//----------------------------------------------------------------------------
// The confidential and proprietary information contained in this file may
// only be used by a person authorised under and to the extent permitted
// by a subsisting licensing agreement from ARM Limited or its affiliates.
//
// (C) COPYRIGHT 2016 ARM Limited or its affiliates.
// ALL RIGHTS RESERVED
//
// This entire notice must be reproduced on all copies of this file
// and copies of this file may only be made by a person if such person is
// permitted to do so under the terms of a subsisting license agreement
// from ARM Limited or its affiliates.
//----------------------------------------------------------------------------
#include "mbed.h"
#include "C12832.h"
#include "OdinWiFiInterface.h"
#include "http_request.h"

// GLOBAL VARIABLES HERE

C12832  lcd(PE_14, PE_12, PD_12, PD_11, PE_9);
OdinWiFiInterface wifi;
InterruptIn button(PF_2);
volatile int count = 0;
volatile bool clicked = false;

// FUNCTION DEFINTIONS HERE

void lcd_print(const char* message) {
    lcd.cls();
    lcd.locate(0, 3);
    lcd.printf(message);
}

void button_clicked() {
    clicked = true;
    count += 1;
    char val[32];
    sprintf(val, "# of clicks = %d", count);
    lcd_print(val);
}

int main() {

    // MAIN CODE HERE

    lcd_print("Connecting...");
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        lcd_print("Connection error.");
        return -1;
    }
    lcd_print("Successfully connected!");

    button.rise(&button_clicked);

    while (true) {
        // WHILE LOOP CODE HERE

        if (clicked) {
            clicked = false;
            char body[140];
            char event_name[] = "Button Clicked";
            NetworkInterface* net = &wifi;
            HttpRequest* request = new HttpRequest(net, HTTP_POST, "http://maker.ifttt.com/trigger/mbed_connect/with/key/SECRET_KEY_HERE");
            request->set_header("Content-Type", "application/json");
            sprintf(body, "{\"value1\":\"%s\", \"value2\":\"%d\"}", event_name, count);
            HttpResponse* response = request->send(body, strlen(body));
            delete request;
        }
    }

}
