/*
  Copyright (c) 2015 ClosedCube Limited

  Permission is hereby granted, free of charge, to any person obtaining a copy of this software
  and associated documentation files (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge, publish, distribute,
  sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or
  substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
  BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "SHT3XA.h"

#define SHT3XA_RH_FORMULA(x)     -12.5f+125.0f*x
#define SHT3XA_TEMPC_FORMULA(x)  -66.875f+218.75f*x
#define SHT3XA_TEMPF_FORMULA(x)  -88.375f+393.75f*x

SHT3XA::SHT3XA(PinName pinRH,PinName pinT) : _pinRH(pinRH),_pinT(pinT)
{
}

float SHT3XA::readRH()
{
    return SHT3XA_RH_FORMULA(_pinRH.read());
}

float SHT3XA::readTempC()
{
    return SHT3XA_TEMPC_FORMULA(_pinT.read());
}

float SHT3XA::readTempF()
{
    return SHT3XA_TEMPF_FORMULA(_pinT.read());
}

