/*
  Copyright (c) 2015 ClosedCube Limited
 
  Permission is hereby granted, free of charge, to any person obtaining a copy of this software
  and associated documentation files (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge, publish, distribute,
  sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:
 
  The above copyright notice and this permission notice shall be included in all copies or
  substantial portions of the Software.
 
  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
  BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
  DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
#ifndef SHT3XA_H
#define SHT3XA_H

#include "mbed.h"

 
//! Library for the Sensirion SHT3X-ARP Analog Humidity & Temperature Sensor.
/*!
 SHT3x-ARP is the next generation of Sensirion’s temperature and humidity sensors. 
 It builds on a new CMOSens sensor chip that is at the heart of Sensirion's new humidity and temperature platform. 
 The SHT3x-ARP has increased intelligence, reliability and improved accuracy specifications compared to its predecessor. 
 Its functionality includes enhanced signal processing, temperature and humidity can be read out at different pins. 
 The DFN package has a footprint of 2.5 x 2.5 mm while keeping a height of 0.9 mm. 
 This allows for integration of the SHT3x-ARP into a great variety of applications. 
 Additionally, the wide supply voltage range of 2.4 to 5.5 V guarantees compatibility with diverse assembly situations. 
 All in all, the SHT3x-ARP incorporates 15 years of knowledge of Sensirion, the leader in the humidity sensor industry.
*/
class SHT3XA
{
    
public:

  //!Creates an instance of the class.
  SHT3XA(PinName pinRH,PinName pinT);

  //!Reads the current humidity level (%RH)
  float readRH();
  
  //!Reads the current temperature in Celsius
  float readTempC();

  //!Reads the current temperature in Fahrenheit
  float readTempF();
  
private:
    AnalogIn _pinRH;
    AnalogIn _pinT;
 
};
 
#endif