/*
 SHT30-ARP-B Analog Humidity & Temperature Sensor Example Code 
 ClosedCube SHT30A-EASY breakout module
 
 License: This example code is in the public domain.
 Date: 14-Sep-2015
  
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE
 */

#include "mbed.h"
#include "SHT3XA.h"

/*
    Hardware connections:
        VDD to 3.3V
        RH to A0
        T to A1
        GND to GND   
*/
SHT3XA sht30a(A0,A1);

Serial pc(USBTX, USBRX);
 
int main() {  
    pc.baud(115200);
    pc.printf("ClosedCube SHT30A-EASY example"); 

    while( true ) {
        pc.printf("T: %3.2fC RH: %3.2f%%\n", sht30a.readTempC(), sht30a.readRH());        
        wait(0.3f);
    }
    
}