#include "mbed.h"
/*
マトリックス・サンプルプログラム
Ver.112201
Rows(dp24, dp25, dp26,  dp2, dp28, dp17, dp18,  dp1)：データ
Cpin(  13,    3,    4,   10,    6,   11,   15,   16)：カソード  

Cols(dp13, dp14,  dp4, dp16,  dp6,  dp9, dp10, dp11)：制御
Apin(   9,   14,    8,   12,    1,    7,    2,    5)：アノード
*/

 BusOut Rows (dp24, dp25, dp26,  dp2, dp28, dp17, dp18,  dp1);
 BusOut Cols (dp13, dp14,  dp4, dp16,  dp6,  dp9, dp10, dp11);
 DigitalOut myled(dp15);

int DotPattern[] = {0x00, //00000000//空データ
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    
                    0x18, //00011000//マーク
                    0x3c, //00111100
                    0x7e, //01111110
                    0xff, //11111111
                    0xdb, //11011011
                    0x99, //10011001
                    0x18, //00011000
                    0x18, //00011000
                    
                    0x00, //00000000//空データ
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    0x00, //00000000
                    };
float count;
float timer;
int offset;
int linecls;
int loop;
int index;

int main() {
    while (1) {
        myled = 1;
        
        //初期化(Matrixリセット)
        index =1;
        for(linecls = 1; linecls<=8; linecls++){
            Cols = (index);
            Rows = 0x00;
            index = index*2;
        }
        //2行目から読み込む、マークの一文字だけ表示あとは順次インクリメント
        offset = 2;
        count =1;
            while (count < 24) {
            timer = 1;
                while (timer < 5000) {
                    index = 1;
                        for(loop =0; loop<=7; loop++) {
                            Cols = index;
                            Rows = DotPattern[offset + loop];
                            index = index*2;
                        }
                    timer++; //タイマー処理中ループ
                }
            offset++;
            count++;
            myled =!myled;
            }
    }
}