//#include "EthernetInterface.h"
#define tps 0.1
#define tpss 0.05
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period
DigitalOut valid(p21);//rajout
void Init(int);//rajout
void lecture(void);//permet lecture intern du pld
Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
// analog input connected to mbed
// valid pmw mbed pin
Serial pc(USBTX, USBRX); // tx, rx
// Top_Hall Pin
float pi=3.14159265359;
int valref=0 ;//rajout
int val=0;
float min ;
float max;
int tout;
int Hall;
int direction;
int FLTA;
int frein;
int overcurrent;
float gaz;


//void modulo (int );

/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"







/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int giCounter=0;// acces counting


/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;



DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received


AnalogIn poignee (p17);
FILE*pfile=NULL;
Ticker guidon;


//************************************************************
InterruptIn tphall (p22);
int lire;
float vitesse;
int cpthall=0;
void cpt(void);
void vit (void);
Ticker ragas;
float ray=0.20;
float Bride;
Timer charo;
float d=0;
float dac;
int kpar;
int ktot;
//************************************************************


void task1(void);
int mode ;
int kirito;

//************ local function prototypes *******************







/**************** Read persistent data from text file located on local file system ****************/



/**************** write persitant  data to text file located on local file system ****************/






//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************






//********************* Timer Interrupt for gaz ref management each 10ms   ********************



/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page
{
    char ma_chaine4[20]= {}; // needed to form html response

}


/*********************** CAN BUS SECTION  **********************/



void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }

}



//*************************** main function *****************************************
int main()
{
    //int x;
    //int data_in;
    char cChoix;
    valid.write(0);
    MyPLD.write(0);
    valid.write(1);
    float gaz;
    mode=0;// mode auto

    FILE* pfile = fopen ("/local/ragas.txt","r");
    if(pfile!=NULL) {
        fscanf(pfile,"min=%f max=%f bride=%f Kpar=%d Ktot=%d", &min,&max,&Bride,&kpar,&ktot);
        pc.printf("\n min=%f max=%f bride=%f Kpar=% Ktot=%d", min,max,Bride,kpar,ktot);
    } else {
        pc.printf("erreur");
    }
    fclose(pfile); // close file
    guidon.attach(&task1,tpss);




    //***************************************************************************************
    tphall.rise(&cpt);
    tphall.mode(PullUp);
    ragas.attach(&vit,tps);
    //****************************************************************************************





//***************************************** web section ********************************************/
//Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
//Thread WebThread(Web_Server_Thread);// create and launch web server thread
    /********* main cgi function used to patch data to the web server thread **********************************/

//******************************************* end web section  ************************************* /




    pc.printf(" programme scooter mbed \n");



//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************


    while(cChoix!='q' and cChoix!='Q' /*and cChoix='c'*/) {

        pc.printf(" veuillez saisir un choix parmi la liste proposee: \r\n");
        pc.printf(" a:saisie consigne pwm \r\n");
        pc.printf(" c:lecture interne \r\n");
        pc.printf(" b:calibration \r\n");
        pc.printf(" v:vitesse\r\n");
        pc.printf(" m:mode \r\n");
        pc.printf(" w:valeur bride \r\n");
        pc.printf(" x:reset \r\n ");
        pc.printf(" k:kilometre \r\n");
        pc.printf(" q:quitter \r\n");

        /************* multithreading : main thread need to sleep in order to allow web response */
        while (pc.readable()==0) { // determine if char availabler
            Thread::wait(10);   // wait 10 until char available on serial input
        }
        /************* end of main thread sleep  ****************/

        pc.scanf(" %c",&cChoix);
        switch (cChoix) {
            case 'a':

                printf("donne moi une valeur de pwmref entre 0 et 255:");
                scanf("%d",&valref);
                if(valref<=255) {
                    //MyPLD.write(valref);
                } else {
                    valref=0;
                    //MyPLD.write(valref);
                    printf("valeur entre 0 et 255");
                }
                break;
            case 'c' :
                lecture();
                break;
            case 'b':
                printf("mettre au  min et appuyer sur une touche quand termine\n\r");
                getchar();
                min=poignee.read();
                printf("min=%f\n\r",min);
                printf("vmettre au max  max et appuyer sur une touche quand termine\n\r");
                getchar();
                max=poignee.read();
                printf("max%f\n\r",max);

                break;
            case 'm':
                do {
                    printf("choisissez un mode :0 pour automatique et 1 pour manuel");
                    scanf("%d",&mode);
                } while(mode<0 || mode >1);
                break ;
            case 'q':
                FILE* pfile = fopen ("/local/ragas.txt","w");
                if(pfile!=NULL)
                    fprintf(pfile,"min=%f max=%f bride=%f kpar=%d ktot=%d", min,max,Bride,kpar,ktot);
                fclose(pfile); // close file
                valid.write(0);
                MyPLD.write(0);
                guidon.detach();
                ragas.detach();
                dac=0;
                break;

            case 'v':
                printf ("vitesse :%g m/s \n",vitesse);
                printf ("vitesse :%g km/h \n",vitesse*3.6);
                printf ("vitesse :%g tr/min \n",(vitesse*60)/(2*pi*ray));
                break ;
            case 'w':
                do {
                    printf("choisissez une valeur de bride");
                    scanf("%g",&Bride);
                } while(Bride<0 || Bride >38.9);
                break ;
                
                case 'k':
                
                d=(((2*pi*ray)/(6*8))*ktot);
                
                printf("distance= %g m\r\n",d);
                
                dac=(((2*pi*ray)/(6*8))*kpar);
               
                printf("distance= %g m\r\n",dac);
                break;
                case 'x' :
                kpar=0;
                break;
                
                

                /*      case 'q':

                frein.read();
                DigitalIn flta.read();
                DigitalIn overcurrent.read();
                DigitalIn direction.read();
                HALLA.read();
                HALLB.read();
                HALLC.read();
                    break;*/
        }
    } // end while

    //************** thread deinit *********************
    //DeInit_Web_Server();
    //bCan_Active=false;
    //CanThread=false;// close can received thread
    pc.printf(" fin programme scooter mbed \n");
} // end main


void lecture (void)
{
    tout = MyPLD.read();
    Hall= tout & 7;
    direction = tout & 8;
    FLTA = tout & 16;
    frein = tout &32;
    overcurrent = tout &64;
    pc.printf("Secteur=%d \t FLTA=%d \t Direction=%d \t Frein=%d \t Overcurrent = %d\n\r",Hall,FLTA,direction,frein,overcurrent);

    if(direction==8) {                                             //direction 1=av  0=ar
        pc.printf("direction avant\n\r");
    } else {
        printf("direction arriere\n\r");
    }

    if(overcurrent==64) {                                           //overcurrent actif=0
        pc.printf("surcharge de courant inactif\n\r");
    } else {
        printf("surcharge de courant actif\n\r");
    }

    if(FLTA == 16) {                                               //FLTA actif=1
        pc.printf("FLTA actif\n\r");
    } else {
        printf("FLTA inactif\n\r");
    }

    if(frein == 32) {                                              //brake actif=0
        pc.printf("Frein inactif\n\r");
    } else {
        pc.printf("Frein actif\n\r");
    }
}



void task1(void)    //0.05seconde
{
    tout = MyPLD.read();
    Hall= tout & 7;
    direction = tout & 8;
    FLTA = tout & 16;
    frein = tout &32;
    overcurrent = tout &64;


    gaz=poignee.read();
    float valPoignee=((255/(max-min))*gaz)-(min*(255)/(max-min));
    if(mode==0) {                         //mode auto
        if(frein==0) {                    //frein actif
            val=0;
        } else  {            //frein inactif

            if(val<valPoignee) {    //incrémentation
                val=val+1;
            } else {                //bonne valeur
                val=valPoignee;
            }
            if(Bride<vitesse*3.6) {
                val=val-1;
            }

            if(val<0) {
                val=0;
            }/*
                    if(val>valPoignee) {    //décrémentation
                        val=val-1;
                    } else {                //bonne valeur
                        val=valPoignee;
                    }
                    if(val>255) {
                        val=255;
                    }
                    if(val<0) {
                        val=0;
                    }
                    kirito=val; //valeur actuel de la pwm dans une variable globale
            } else {
                MyPLD.write(kirito);
            }*/
        }
    } else {             //mode manuel
        val=valref;      //valeurs dans le case "a"
    }
    //val=127;
    MyPLD.write(val);
}
void cpt (void)
{
    cpthall++;
}

void vit (void)
{
    lire=cpthall;
    cpthall=0;
    vitesse=(((2*pi*ray)/(6*8))*lire)/tps;
    /*if (vitesse!=0) 
    {

        charo.start();
        vitesse=vitesse/3600;
    } 
    else 
    {
        charo.stop();
    }
    
    d=d+vitesse*charo;
    dac=dac+vitesse*charo;
    charo.reset();*/
   kpar=kpar+lire;
   ktot=ktot+lire;
}
