# Freshen - device management framework

See https://freshen.cc for the full description and documentation

## Example mbedOS app

```c

#include "mbed.h"
#include "EthernetInterface.h"

#define FRESHEN_ENABLE_DASH
#include "freshen.h"
static struct freshen_ctx ctx;

EthernetInterface net;
DigitalOut myled(LED1);

static int echo(const char *arg, char *buf, size_t len, void *userdata) {
  snprintf(buf, len, "%s", arg);
  return 0;
}

int main() {
    net.connect();
    freshen_net = &net;
    freshen_core_export(&ctx, "echo", echo, NULL);

    while(1) {
        const char *ip = net.get_ip_address();
        printf("IP address is: %s\n", ip ? ip : "No IP");

        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);

        freshen_poll_dash(&ctx, "1.2", "ACCESS_TOKEN");
    }
}

```