/** Seed Team 20 - Michael Zonnenberg
    Board: Arch GPRS V2
    Sensors: DHT11 temp&humidity
 */
 
 #include "mbed.h"
 #include "ARCH_GPRS_V2_HW.h"
 #include "HTTPClient.h"
 #include "GPRSInterface.h"
 #include "Blinker.h"
 #include "DHT.h"
 #include "i2c_uart.h"
 #include "ARCH_GPRS_Sleep.h"
 
//LED Blink
Blinker yellowLED(LED1), redLED(LED2), greenLED(LED3), blueLED(LED4);

//DHT11 Sensor
int temp, humidity;
DHT sensor(P1_14, DHT11);

//TEMT6000 Ambient Light Sensor, Using P0_12
int light;
AnalogIn lightSensor(P0_12);

#define BROADCAST_TIME            100     
#define THINGSPEAK_APIKEY "QY931S2NP23LG9IM"    
                 
#define HTTP_POST_URL "http://api.thingspeak.com/update"

#define TEST_HTTP_GET       1
#define TEST_HTTP_POST      1
#define TEST_HTTP_PUT       1
#define TEST_HTTP_DELETE    1

#define PIN_TX                  P1_27
#define PIN_RX                  P1_26

#define TS_FEED_ID              25152
#define TS_API                  "JDMPGG7T7O8OY45M"

char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = TS_API;
char urlBuffer[256];
char timeBuffer[64];
char str[1024];
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"internetd.gdsp",NULL,NULL);
HTTPClient http;
/** 
    Function sends args to thingskpeak
    Blinks green LED 5 times if success
    Blinks red LED 5 times if failure
    @param temperature The temperaure measurment from sensor
    @param humidity The humidity measurment from sensor
    @param light The light measurement from analog sensor
 */
void sendToThingSpeak(int sensor1, int sensor2, int sensor3){
    iot_hw.init(); // power on SIM900
    
    int count = 0;
    while(false == gprs.connect() && count < 5) {
        wait(2);
        count += 1;
    }

    // format url here
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field1=%d&field2=%d&field3=%d", thingSpeakUrl, thingSpeakKey, sensor1, sensor2,sensor3);

    // send request
    HTTPResult res = http.get(urlBuffer, str,128);
    // and verify the result
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

/** 
    Function returns temperature and hunidity reading
    from DHT11 sensor
    @return temp The temperature in Farenheit
    @return hunidity The percent hunidity
 */
void getTempHumid(int* temp,int* humidity){
    int err = 1;
    int count = 0;
    iot_hw.grovePwrOn();
    wait(1); // wait 1 second for device stable status
    while (err != 0 && count < 4) {
        err = sensor.readData();
        count += 1;
        *temp = sensor.ReadTemperature(FARENHEIT);
        *humidity = sensor.ReadHumidity();
        
        wait(1);
        } 
    iot_hw.grovePwrOff();    
}   

/** Function returns a light reading between 0 and 1000
    TEMT600 analog ambient light sensor
    @return light The light reading use to measure lights on/off
    */
void getLightReading(int* light)
{
        *light = lightSensor*1000;
}


int main()
{
    wdt_sleep.wdtClkSetup(WDTCLK_SRC_IRC_OSC);

    PWRON:
    //get temp and hunidity
    getTempHumid(&temp,&humidity);
    //get light reading
    getLightReading(&light);

    //upload to thingspeak
    sendToThingSpeak(temp,humidity,light); //blinks green if success, blinks red if failure
    
    //sleep for BROADCAST_TIME defined above. WFI with WDT
    wdt_sleep.sleep(BROADCAST_TIME);
    
    goto PWRON;
}