/** Seed Team 20 - Michael Zonnenberg
    Board: Arch GPRS V2
    Sensors: DHT11 temp&humidity
 */
 
 #include "mbed.h"
 #include "DHT.h"
 #include "SDFileSystem.h"
 #include "GPRSInterface.h"
 #include "HTTPClient.h"
 #include "ARCH_GPRS_Sleep.h"

 
//LED Blink Functions
DigitalOut yellowled(LED1);
DigitalOut redled(LED2);
DigitalOut greenled(LED3);
DigitalOut blueled(LED4);
void blinkYELLOW(void){
    yellowled = 1;
    wait(0.5);
    yellowled = 0;
    wait(0.5);
    yellowled = 1;
    wait(0.5);
    yellowled = 0;
    wait(0.5);  
}
void blinkRED(void){
    redled = 1;
    wait(0.5);
    redled = 0;
    wait(0.5);
    redled = 1;
    wait(0.5);
    redled = 0;
    wait(0.5);  
}
void blinkBLUE(void){
    blueled = 1;
    wait(0.5);
    blueled = 0;
    wait(0.5);
    blueled = 1;
    wait(0.5);
    blueled = 0;
    wait(0.5);  
}
void blinkGREEN(void){
    greenled = 1;
    wait(0.5);
    greenled = 0;
    wait(0.5);
    greenled = 1;
    wait(0.5);
    greenled = 0;
    wait(0.5);  
}



#define PIN_PWR                 P1_2    //power up gprs module
#define PIN_PWR_KEY             P1_7
#define PIN_TX                  P1_27
#define PIN_RX                  P1_26
DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);
void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);
 
    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}
void gprsPowerDown(void)
{
   power = 1;
   wait(2);
   power = 0;
   wait(2); 
}

#define TEST_HTTP_GET       1
#define TEST_HTTP_POST      1
#define TEST_HTTP_PUT       1
#define TEST_HTTP_DELETE    1

#define TS_FEED_ID              25152
#define TS_API                  "QY931S2NP23LG9IM"

char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "QY931S2NP23LG9IM";
char urlBuffer[256];
char timeBuffer[64];
char str[1024];
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"internetd.gdsp",NULL,NULL);
HTTPClient http;

/** 
    Function sends args to thingskpeak
    @param temperature The temperaure measurment from sensor
    @param humidity The humidity measurment from sensor
 */
void sendToThingSpeak(float temperature, float humidity){
    //turn on cellular module
    gprsPowerUp();

    gprs.init();
    
    int count = 0;
    while(false == gprs.connect() && count < 5) {
        wait(2);
        count += 1;
    }

    // format url here
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field1=%f&field2=%f", thingSpeakUrl, thingSpeakKey, temperature, humidity);

    // send request
    HTTPResult res = http.get(urlBuffer, str,128);
    // and verify the result
    if (res != HTTP_OK) {
        blinkRED();
    } else {
        blinkGREEN();
    }
    gprsPowerDown();
}

/** 
    Function sends args to thingskpeak
    @return temp and humid values from DHT11 sensor
 */
DHT sensor(P1_14, DHT11);
DigitalOut POWER(P1_3); //drive low to activate pins
void getTempHumid(float* temp, float* humid){
   int err = 1;
    wait(1); // wait 1 second for device stable status
    POWER.write(0);
    while (err != 0) {
        err = sensor.readData();
        *temp = sensor.ReadTemperature(FARENHEIT);
        *humid = sensor.ReadHumidity();
        wait(1);
        }     
}   

/** 
    Function writes data to sd card (comma seperated)
    @param temperature The temperaure measurment from sensor
    @param humidity The humidity measurment from sensor
 */
SDFileSystem sd(P1_22, P1_21, P1_20, P1_23, "sd"); // the pinout on the /Arch GPRS v2 mbed board.
void sdWrite(double temp, double humid)
{
    mkdir("/sd", 0777);           // All other times open file in append mode
    FILE *fp = fopen("/sd/node1.csv","a");
    fprintf(fp,"%4.2f, %4.2f\r\n",temp, humid);
    fclose(fp);
    blinkBLUE();
}

///////////////////////////////////////////////////////////////////////
#define BROADCAST_TIME      25     //sleep time
float temp,humid; 

int main(){
    
    wdt_sleep.wdtClkSetup(WDTCLK_SRC_IRC_OSC);
    
    PWRON:
    // get temp and humidity
    getTempHumid(&temp, &humid);
    
    sdWrite(temp, humid);

    // send data to ThingSpeak.com
    sendToThingSpeak(temp, humid);
    
    //sleep
    wdt_sleep.sleep(BROADCAST_TIME);
    
    //wake
    goto PWRON;
    
        
    
}