//SEED Team 20 Final Code draft 1 4/16/15
 
#include "mbed.h"
#include "SDFileSystem.h"
#include "ARCH_GPRS_V2_HW.h"
#include "HTTPClient.h"
#include "GPRSInterface.h"
#include "Blinker.h"
#include "DHT.h"
#include "i2c_uart.h"
#include "ARCH_GPRS_Sleep.h"
#include "ds1307.h"
//#include "USBSerial.h"
#include <string>

//Arch GPRS v2 SIM900 pins
#define PIN_TX                  P1_27
#define PIN_RX                  P1_26

//RTC
#define SDA    P0_5
#define SCL    P0_4 

#define BROADCAST_TIME            300 //time between sending data [sec]  

//USBSerial pc;

//LED Blink
DigitalOut line11(P0_9);
DigitalOut line13(P0_2);
DigitalOut line14(P1_28);

//Blinker yellowLED(LED1), redLED(LED2), greenLED(LED3), blueLED(LED4);
 Blinker blueLED(P0_9), greenLED(P0_2), redLED(P1_28);
//USBSerial pc;
SDFileSystem sd(P1_22, P1_21, P1_20, P1_23, "sd"); // the pinout on the /Arch GPRS v2 mbed board.
char filename[60];

//RTC
DS1307 rtc(SDA,SCL);
int sec, minute, hours, day, date, month, year;
char timestamp[17];

//variables for reading data from SD card
char APIKey[17];
char sensors[3][5];
char sensorBuff[5];
int tempField, humField, lightField;
int field1, field2, field3;
int numSensors;
bool tempSensorflag=false, lightSensorflag=false, SomeotherSensorflag=false;

//GPRS setup
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"internetd.gdsp",NULL,NULL);
HTTPClient http;
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char urlBuffer[256];
char str[1024];
//char errorR[1024];
string errorR;

//Sensors
DHT sensor(P1_14,SEN51035P);
//DHT sensor(P1_14,SEN11301P); //grove connected DHT22
AnalogIn lightSensor(P0_12); //TEMT6000 sparkfun break out board ambient light sensor

int tempData,humData, lightData; //variables to hold enviroment

//method to connect GPRS to the network
//@return true if successful, false if failed
bool connectGPRS(void) {
    iot_hw.init(); // power on SIM900
    int count = 0;
    while(false == gprs.connect() && count < 5) {
        wait(2);
        count += 1;
    }
    if (count != 5) return true; // success!
    else return false; //failed
}

//method to collect temperature and humidity
//using grove DHT22 sensors connected to P1_14, P1_13
void getTempHumid(int* tempData,int* humData){
    int err = 1;
    int count = 0;
    iot_hw.grovePwrOn(); // power on grove pins
    wait(1); // wait 1 second for device stable status
    while (err != 0 && count < 4) {
        err = sensor.readData();
        count += 1;
        *tempData = sensor.ReadTemperature(FARENHEIT);
        *humData = sensor.ReadHumidity();  
        wait(1);
        } 
    
    iot_hw.grovePwrOff();  //power down grove pins  
}  

//method to collect light level data
//using TEMT6000 sparkfun breakout board
void getLightReading(int* lightData)
{
        *lightData = lightSensor*1000;
}

//method to write error reports to ErrorLog.txt file on SD card
void errorWrite(string errorReport) {
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year); //get time from RTC
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec); // create timmestamp
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/ErrorLog.txt","a");
    if (fp == NULL) {
        blueLED.blink(10); //no sd card blink blue 10 times
    } else {
        //pc.printf("%s: %s \r\n",timestamp,errorReport);
        fprintf(fp,"%s: %s \r\n",timestamp,errorReport); 
        fclose(fp);
        blueLED.blink(5);
    }
}

//method to read config.txt file on SD card
bool ReadFile (void) {    
    mkdir("/sd", 0777);           // All other times open file in append mode
    FILE *fp = fopen("/sd/config.txt","r");
    if (fp==NULL) {
        fclose(fp);
        blueLED.blink(10);
        errorR="Read config.txt file error on SD card";
        errorWrite(errorR);
        return false;
        
    } else if (fp) {        

        fscanf(fp,"%16c",APIKey);        
        fscanf(fp,"%d",&numSensors);
       
        for (int i = 0; i<numSensors;i=i+1) {
            fscanf(fp,"%s",sensorBuff); 
            strcpy(sensors[i],sensorBuff);
        }
        
        fclose(fp);
        return true;
    
    } else {
        fclose(fp);
        blueLED.blink(10);
        errorR="Read config.txt file error on SD card";
        errorWrite(errorR);
        return false;
    }
        
}

bool stringComparison (const char *string1, const char *string2) {
  int count = 0;
  while (string1[count] != 0) {
    if (string1[count] != string2[count])
      return false;
    count++;
  }
  return true;
}


//method to send 1 field of data to ThingsSpeak
//blinks green 5 times if successful
//blinks red 5 times if get statement fails
//blinks red 10 times if fails to connectGPRS
void sendData1(int sensor1Data, int field1)
{
    if (connectGPRS() == true) { //connect is success
        urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?key=%s&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data); //create url 
        HTTPResult res = http.get(urlBuffer, str,128); //send get request
        if (res != HTTP_OK) {
             redLED.blink(5);           //get statement failed blink red 5 times
            errorR="HTTP Request Error";
            errorWrite(errorR);
        } else greenLED.blink(5);                        //get statement success blink green 5 times
        iot_hw.init_io();                              //power down SIM900
          
    } else { //failed to connectGPRS
        redLED.blink(10); //blink red 10 times
        iot_hw.init_io(); //power down SIM900
        errorR="Failed to connect to GPRS";
        errorWrite(errorR);
    }
}

//method to send 2 field of data to ThingsSpeak
void sendData2(int sensor1Data, int field1, int sensor2Data, int field2)
{
    if (connectGPRS() == true) {
        urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data); //create url
        HTTPResult res = http.get(urlBuffer, str,128); //send get request
        if (res != HTTP_OK) {
             redLED.blink(5);           //get statement failed blink red 5 times
            errorR="HTTP Request Error";
            errorWrite(errorR);
        } else greenLED.blink(5);                        //get statement success blink green 5 times
        iot_hw.init_io();                              //power down SIM900
          
    } else { //failed to connectGPRS
        redLED.blink(10); //blink red 10 times
        iot_hw.init_io(); //power down SIM900
        errorR="Failed to connect to GPRS";
        errorWrite(errorR);
    }
}

//method to send 3 field of data to ThingsSpeak
void sendData3(int sensor1Data, int field1, int sensor2Data, int field2, int sensor3Data, int field3)
{
    if (connectGPRS() == true) {
        urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data, field3, sensor3Data); //create url to send
        HTTPResult res = http.get(urlBuffer, str,128); //send get request
        if (res != HTTP_OK) {
            redLED.blink(5);           //get statement failed blink red 5 times
            errorR="HTTP Request Error";
            errorWrite(errorR);
        } else greenLED.blink(5);                        //get statement success blink green 5 times
        iot_hw.init_io();                              //power down SIM900
          
    } else { //failed to connectGPRS
        redLED.blink(10); //blink red 10 times
        iot_hw.init_io(); //power down SIM900
        errorR="Failed to connect to GPRS";
        errorWrite(errorR);
    }
}



//writes data to SDcard for 1 field
//if no SDcard blink blue 10 times 
void sdWrite1(int sensor1Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year); //get time from RTC
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec); //create time stamp
    
    mkdir("/sd", 0777);
    //FILE *fp = fopen("/sd/node1.csv","a");
    FILE *fp = fopen(filename,"a");

    if (fp == NULL) {
        blueLED.blink(10); //no sd Card blink Blue 10 times
    } else {
        fprintf(fp,"%s, %d \r\n",timestamp,sensor1Data); //write time stamp and data to microSD
        fclose(fp);
        blueLED.blink(5);
    }
}

//writes data to SDcard for 2 fields
//if no SDcard blink blue 10 times 
void sdWrite2(int sensor1Data, int sensor2Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year); //get time from RTC
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec); //create timestamp
    
    mkdir("/sd", 0777);
    //FILE *fp = fopen("/sd/node1.csv","a");
    FILE *fp = fopen(filename,"a");

    if (fp == NULL) {
        blueLED.blink(10); //no sd Card blink blue 10 times
    } else {
        fprintf(fp,"%s, %d, %d\r\n",timestamp, sensor1Data, sensor2Data); //write timestamp+data to SD
        fclose(fp);
        blueLED.blink(5);
    }
}

//writes data to SDcard for 3 fields
//if no SDcard blink blue 10 times 
void sdWrite3(int sensor1Data, int sensor2Data,int sensor3Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year); //get time from RTC
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec); //create timestamp
    
    mkdir("/sd", 0777);
    //FILE *fp = fopen("/sd/node1.csv","a");
    FILE *fp = fopen(filename,"a");
    if (fp == NULL) {
        blueLED.blink(10); //no sd card blink blue 10 times
    } else {
        fprintf(fp,"%s, %d, %d, %d\r\n",timestamp, sensor1Data, sensor2Data, sensor3Data); //write timestamp+data to sd
        fclose(fp);
        blueLED.blink(5);
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
int main() {
    wdt_sleep.wdtClkSetup(WDTCLK_SRC_IRC_OSC); //set up sleep
    wait(2);
    
        
    //read SD card
    while(ReadFile()==false) {
        wait(5);
        blueLED.blink(10);
    }
    greenLED.blink(10);
    

    //identify sensors and find order of fields
    int field=1;
    for (int i=0;i<numSensors;i=i+1) {
        if (stringComparison(sensors[i],"temp")==true) {
            tempSensorflag=true;
            tempField=field;
            humField=field+1;
            field=field+1;
        } else if (stringComparison(sensors[i],"light")==true) {
            lightSensorflag=true;
            lightField=field;
        } else if (stringComparison(sensors[i],"some other sensor")==true) {
            SomeotherSensorflag=true;
        }
        field=field+1;
    }
    
    //set up CSV file
    mkdir("/sd", 0777);
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(filename,"/sd/DataLog_20%.2d.%.2d.%.2d_%.2d.%.2d.csv",year, month, date, hours, minute);
    FILE *fp = fopen(filename,"a");
    if (fp == NULL) {
        //no sd card
        blueLED.blink(10);
    } else {
        
        //print header
        fprintf(fp,"Timestamp, sensor1, sensor2 \r\n");
        fclose(fp);
        blueLED.blink(5);
    }
    
    //Debug Mode

    for (int dd=0;dd<30;dd=dd+1) {

        if (numSensors == 3) {
                
            } else if (numSensors ==2) {

                if (tempSensorflag==true) {

                    if (lightSensorflag==true) {
                        getLightReading(&lightData);
                        getTempHumid(&tempData,&humData);
                        sendData3(tempData,tempField,humData,humField,lightData,lightField);
                        sdWrite3(tempData,humData,lightData);
                    } else if (SomeotherSensorflag==true) {
                         
                    }  
                } else if (lightSensorflag==true) {
               

                    if (SomeotherSensorflag==true) {
                        getLightReading(&lightData);
                        
                        
                    }
                }   
            } else {
                if (tempSensorflag==true) {
                    getTempHumid(&tempData,&humData);
                    sendData2(tempData,tempField,humData,humField);
                    sdWrite2(tempData,humData);
                } else if (lightSensorflag==true) {
                    getLightReading(&lightData);
                    sendData1(lightData,lightField);
                    sdWrite1(lightData);
                } else if (SomeotherSensorflag==true) {
                    
                }
            }
            wait(30);
        }
        

    
    
    
    //normal mode
    while (1) {
        
        if (numSensors == 3) {
            
        } else if (numSensors ==2) {
            if (tempSensorflag==true) {
                if (lightSensorflag==true) {
                    getLightReading(&lightData);
                    getTempHumid(&tempData,&humData);
                    sendData3(tempData,tempField,humData,humField,lightData,lightField);
                    sdWrite3(tempData,humData,lightData);
                } else if (SomeotherSensorflag==true) { 
                
                }  
            } else if (lightSensorflag==true) {
                if (SomeotherSensorflag==true) {
                    getLightReading(&lightData);
                    
                    
                }
            }   
        } else {
            if (tempSensorflag==true) {
                getTempHumid(&tempData,&humData);
                sendData2(tempData,tempField,humData,humField);
                sdWrite2(tempData,humData);
            } else if (lightSensorflag==true) {
                getLightReading(&lightData);
                sendData1(lightData,lightField);
                sdWrite1(lightData);
            } else if (SomeotherSensorflag==true) {
                
            }
        }
        wdt_sleep.sleep(BROADCAST_TIME);
    
    }
}