//SEED Team 20 Final Code draft 1 4/16/15

#include "mbed.h"
#include "SDFileSystem.h"
#include "ARCH_GPRS_V2_HW.h"
#include "HTTPClient.h"
#include "GPRSInterface.h"
#include "Blinker.h"
#include "DHT.h"
#include "i2c_uart.h"
#include "ARCH_GPRS_Sleep.h"
#include "ds1307.h"
#include "USBSerial.h"
#include <string>

#define PIN_TX                  P1_27
#define PIN_RX                  P1_26

#define SDA    P0_5
#define SCL    P0_4 

 
#define BROADCAST_TIME            300    

USBSerial pc;

//LED Blink
DigitalOut line11(P0_9);
DigitalOut line13(P0_2);
DigitalOut line14(P1_28);

Blinker yellowLED(LED1), redLED(LED2), greenLED(LED3), blueLED(LED4);

//USBSerial pc;
SDFileSystem sd(P1_22, P1_21, P1_20, P1_23, "sd"); // the pinout on the /Arch GPRS v2 mbed board.
char filename[60];

//RTC
DS1307 rtc(SDA,SCL);
int sec, minute, hours, day, date, month, year;
char timestamp[17];

//variables for reading data from SD card
char APIKey[17];
char sensors[3][5];
char sensorBuff[5];
int tempField, humField, lightField;
int field1, field2, field3;
int numSensors;
bool tempSensorflag=false, lightSensorflag=false, SomeotherSensorflag=false;

//GPRS setup
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"internetd.gdsp",NULL,NULL);
HTTPClient http;
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char urlBuffer[256];
char str[1024];
//char errorR[1024];
string errorR;

//Sensors
//DHT sensor(P1_14,SEN51035P);
DHT sensor(P1_14,SEN11301P);
AnalogIn lightSensor(P0_12);


int tempData,humData, lightData;


void connectGPRS(void) {
    iot_hw.init(); // power on SIM900
    
    int count = 0;
    while(false == gprs.connect() && count < 5) {
        wait(2);
        count += 1;
    }
}

void getTempHumid(int* tempData,int* humData){
    int err = 1;
    int count = 0;
    iot_hw.grovePwrOn();
    wait(1); // wait 1 second for device stable status
    while (err != 0 && count < 4) {
        err = sensor.readData();
        count += 1;
        *tempData = sensor.ReadTemperature(FARENHEIT);
        *humData = sensor.ReadHumidity();
        
        wait(1);
        } 
    iot_hw.grovePwrOff();    
}  

void getLightReading(int* lightData)
{
        *lightData = lightSensor*1000;
}


int ReadFile (void) {    
    mkdir("/sd", 0777);           // All other times open file in append mode
    FILE *fp = fopen("/sd/config.txt","r");
    if (fp==NULL) {
        fclose(fp);
        return 0;
        
    } else if (fp) {        
        //fscanf(fp,"%16c %d %s %s", APIKey, &numSensors, sensors[0],sensors[1]);
        fscanf(fp,"%16c",APIKey);
        
//        pc.printf("APIKEY= %s\r\n",APIKey);
//        
        fscanf(fp,"%d",&numSensors);
//        pc.printf("number of sensors = %d \r\n",numSensors);
//        
        for (int i = 0; i<numSensors;i=i+1) {
            fscanf(fp,"%s",sensors[i]); 
            //fscanf(fp,"%s",sensorBuff); 
            strcpy(sensors[i],sensorBuff);
            //pc.printf("sensor %d = %s\r\n",i,sensors[i]); 
        }
        

        fclose(fp);
        return 1;
    
    } else {
        fclose(fp);
        return 0;
    }
        
}

bool stringComparison (const char *string1, const char *string2) {
  int count = 0;
  while (string1[count] != 0) {
    if (string1[count] != string2[count])
      return false;
    count++;
  }
  return true;
}


void sendData1(int sensor1Data, int field1) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    
    
    iot_hw.init_io(); //power down SIM900
}

void sendData2(int sensor1Data, int field1, int sensor2Data, int field2) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

void sendData3(int sensor1Data, int field1, int sensor2Data, int field2, int sensor3Data, int field3) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data, field3, sensor3Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

//void errorWrite(const char* errorReport) {
void errorWrite(string errorReport) {
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/ErrorLog.txt","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {
        pc.printf("%s: %s \r\n",timestamp,errorReport);
        fprintf(fp,"%s: %s \r\n",timestamp,errorReport);
        fclose(fp);
        blueLED.blink(5);
    }
}

void sdWrite1(int sensor1Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d \r\n",timestamp,sensor1Data);
        fclose(fp);
        blueLED.blink(5);
    }
}

void sdWrite2(int sensor1Data, int sensor2Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d, %d\r\n",timestamp, sensor1Data, sensor2Data);
        fclose(fp);
        blueLED.blink(5);
    }
}

void sdWrite3(int sensor1Data, int sensor2Data,int sensor3Data)
{
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d, %d, %d\r\n",timestamp, sensor1Data, sensor2Data, sensor3Data);
        fclose(fp);
        blueLED.blink(5);
    }
}




int main() {
    wdt_sleep.wdtClkSetup(WDTCLK_SRC_IRC_OSC); //set up sleep
    

    
    //test of breadboard
//    while (1) {
//        //rtc test
//        errorR="Test rtc";
//        rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
//        sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, minute, sec);
//        pc.printf("%s: %s\r\n",timestamp,errorR);
//        
//        //rgb test
//        int n=5;
//        int t=1;
//        pc.printf("line11 blink\r\n");
//        for (int i = 0; i < n; i++) {
//            line11 = 1;
//            wait(t);
//            line11 = 0;
//            wait(t);
//        }
//
//        pc.printf("line13 blink\r\n");
//
//        for (int i = 0; i < n; i++) {
//            line13 = 1;
//            wait(t);
//            line13 = 0;
//            wait(t);
//        }
//        
//        pc.printf("line11 blink\r\n");
//
//        for (int i = 0; i < n; i++) {
//            line14 = 1;
//            wait(t);
//            line14 = 0;
//            wait(t);
//        }
//        //light sensor test
//        getLightReading(&lightData);
//        pc.printf("light reading: %d \r\n",lightData);
//        
//        wait(15);
//    }
    
        
    //read SD card
    while (ReadFile()==0) {
        wait(5);
        redLED.blink(10);
    }
    greenLED.blink(10);
    

    //identify sensors and find order of fields
    int field=1;
    for (int i=0;i<numSensors;i=i+1) {
        if (stringComparison(sensors[i],"temp")==true) {
            tempSensorflag=true;
            tempField=field;
            humField=field+1;
            field=field+1;
        } else if (stringComparison(sensors[i],"light")==true) {
            lightSensorflag=true;
            lightField=field;
        } else if (stringComparison(sensors[i],"some other sensor")==true) {
            SomeotherSensorflag=true;
        }
        field=field+1;
    }
    
    //set up CSV file
    mkdir("/sd", 0777);
    rtc.gettime( &sec, &minute, &hours, &day, &date, &month, &year);
    sprintf(filename,"/sd/DataLog_20%.2d.%.2d.%.2d_%.2d.%.2d.csv",year, month, date, hours, minute);
    FILE *fp = fopen(filename,"a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {
        
        //print header
        fprintf(fp,"Timestamp, sensor1, sensor2 \r\n");
        fclose(fp);
        blueLED.blink(5);
    }
    
    //Debug Mode
    for (int dd=0;dd<30;dd=dd+1) {
        
        if (numSensors == 3) {
                
            } else if (numSensors ==2) {
                if (tempSensorflag==true) {
                    if (lightSensorflag==true) {
                        getLightReading(&lightData);
                        getTempHumid(&tempData,&humData);
                        sendData3(tempData,tempField,humData,humField,lightData,lightField);
                        sdWrite3(tempData,humData,lightData);
                    } else if (SomeotherSensorflag==true) { 
                    
                    }  
                } else if (lightSensorflag==true) {
                    if (SomeotherSensorflag==true) {
                        getLightReading(&lightData);
                        
                        
                    }
                }   
            } else {
                if (tempSensorflag==true) {
                    getTempHumid(&tempData,&humData);
                    sendData2(tempData,tempField,humData,humField);
                    sdWrite2(tempData,humData);
                } else if (lightSensorflag==true) {
                    getLightReading(&lightData);
                    sendData1(lightData,lightField);
                    sdWrite1(lightData);
                } else if (SomeotherSensorflag==true) {
                    
                }
            }
            wait(30);
        }
        
    
    
    
    
    //normal mode
    while (1) {
        
        if (numSensors == 3) {
            
        } else if (numSensors ==2) {
            if (tempSensorflag==true) {
                if (lightSensorflag==true) {
                    getLightReading(&lightData);
                    getTempHumid(&tempData,&humData);
                    sendData3(tempData,tempField,humData,humField,lightData,lightField);
                    sdWrite3(tempData,humData,lightData);
                } else if (SomeotherSensorflag==true) { 
                
                }  
            } else if (lightSensorflag==true) {
                if (SomeotherSensorflag==true) {
                    getLightReading(&lightData);
                    
                    
                }
            }   
        } else {
            if (tempSensorflag==true) {
                getTempHumid(&tempData,&humData);
                sendData2(tempData,tempField,humData,humField);
                sdWrite2(tempData,humData);
            } else if (lightSensorflag==true) {
                getLightReading(&lightData);
                sendData1(lightData,lightField);
                sdWrite1(lightData);
            } else if (SomeotherSensorflag==true) {
                
            }
        }
        wdt_sleep.sleep(BROADCAST_TIME);
    
    }
}