//SEED Team 20 Final Code draft 1 4/16/15

#include "mbed.h"
#include "SDFileSystem.h"
#include "ARCH_GPRS_V2_HW.h"
#include "HTTPClient.h"
#include "GPRSInterface.h"
#include "Blinker.h"
#include "DHT.h"
#include "i2c_uart.h"
#include "ARCH_GPRS_Sleep.h"
#include "ds1307.h"
 
#define PIN_TX                  P1_27
#define PIN_RX                  P1_26

#define SDA    P0_5
#define SCL    P0_4 
 
#define BROADCAST_TIME            300    
//LED Blink
Blinker yellowLED(LED1), redLED(LED2), greenLED(LED3), blueLED(LED4);

//USBSerial pc;
SDFileSystem sd(P1_22, P1_21, P1_20, P1_23, "sd"); // the pinout on the /Arch GPRS v2 mbed board.

//RTC
DS1307 rtc(SDA,SCL);
int sec, min, hours, day, date, month, year;
char timestamp[17];

//variables for reading data from SD card
char APIKey[17];
char sensors[3][5];
char sensorBuff[5];
int tempField, humField, lightField;
int field1, field2, field3;
int numSensors;
bool tempSensorflag=false, lightSensorflag=false, SomeotherSensorflag=false;

//GPRS setup
GPRSInterface gprs(PIN_TX,PIN_RX,115200,"internetd.gdsp",NULL,NULL);
HTTPClient http;
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char urlBuffer[256];
char str[1024];

//Sensors
DHT sensor(P1_14,SEN51035P);
AnalogIn lightSensor(P0_12);


int tempData,humData, lightData;


void connectGPRS(void) {
    iot_hw.init(); // power on SIM900
    
    int count = 0;
    while(false == gprs.connect() && count < 5) {
        wait(2);
        count += 1;
    }
}

void getTempHumid(int* tempData,int* humData){
    int err = 1;
    int count = 0;
    iot_hw.grovePwrOn();
    wait(1); // wait 1 second for device stable status
    while (err != 0 && count < 4) {
        err = sensor.readData();
        count += 1;
        *tempData = sensor.ReadTemperature(FARENHEIT);
        *humData = sensor.ReadHumidity();
        
        wait(1);
        } 
    iot_hw.grovePwrOff();    
}  

void getLightReading(int* lightData)
{
        *lightData = lightSensor*1000;
}


int ReadFile (void) {    
    mkdir("/sd", 0777);           // All other times open file in append mode
    FILE *fp = fopen("/sd/config.txt","r");
    if (fp==NULL) {
        fclose(fp);
        return 0;
        
    } else if (fp) {        
        fscanf(fp,"%16c %d %s %s", APIKey, &numSensors, sensors[0],sensors[1]);
//        fscanf(fp,"%16c",APIKey);
//        pc.printf("APIKEY= %s\r\n",APIKey);
//        
//        fscanf(fp,"%d",&numSensors);
//        pc.printf("number of sensors = %d \r\n",numSensors);
//        
//        for (int i = 0; i<numSensors;i=i+1) {
//            //fscanf(fp,"%s",sensors[i]); 
//            fscanf(fp,"%s",sensorBuff); 
//            strcpy(sensors[i],sensorBuff);
//            pc.printf("sensor %d = %s\r\n",i,sensors[i]); 
//        }
        

        fclose(fp);
        return 1;
    
    } else {
        fclose(fp);
        return 0;
    }
        
}

bool stringComparison (const char *string1, const char *string2) {
  int count = 0;
  while (string1[count] != 0) {
    if (string1[count] != string2[count])
      return false;
    count++;
  }
  return true;
}


void sendData1(int sensor1Data, int field1) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

void sendData2(int sensor1Data, int field1, int sensor2Data, int field2) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

void sendData3(int sensor1Data, int field1, int sensor2Data, int field2, int sensor3Data, int field3) {
    connectGPRS();
    urlBuffer[0] = 0;
    sprintf(urlBuffer, "%s?key=%s&field%d=%d&field%d=%d&field%d=%d", thingSpeakUrl, APIKey, field1, sensor1Data, field2, sensor2Data, field3, sensor3Data);
    HTTPResult res = http.get(urlBuffer, str,128);
    if (res != HTTP_OK) {
        redLED.blink(5);
    } else {
        greenLED.blink(5);
    }
    iot_hw.init_io(); //power down SIM900
}

void sdWrite1(int sensor1Data)
{
    rtc.gettime( &sec, &min, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, min, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d \r\n",timestamp,sensor1Data);
        fclose(fp);
        blueLED.blink(5);
    }
}

void sdWrite2(int sensor1Data, int sensor2Data)
{
    rtc.gettime( &sec, &min, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, min, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d, %d\r\n",timestamp, sensor1Data, sensor2Data);
        fclose(fp);
        blueLED.blink(5);
    }
}

void sdWrite3(int sensor1Data, int sensor2Data,int sensor3Data)
{
    rtc.gettime( &sec, &min, &hours, &day, &date, &month, &year);
    sprintf(timestamp,"20%.2d-%.2d-%.2d %.2d:%.2d:%.2d", year, month, date, hours, min, sec);
    
    mkdir("/sd", 0777);
    FILE *fp = fopen("/sd/node1.csv","a");
    if (fp == NULL) {
        //no sd card
        redLED.blink(10);
    } else {

        fprintf(fp,"%s, %d, %d, %d\r\n",timestamp, sensor1Data, sensor2Data, sensor3Data);
        fclose(fp);
        blueLED.blink(5);
    }
}




int main() {
    wdt_sleep.wdtClkSetup(WDTCLK_SRC_IRC_OSC); //set up sleep
        
    //read SD card
    while (ReadFile()==0) {
        wait(5);
        redLED.blink(5);
    }
    greenLED.blink(10);

    //identify sensors and find order of fields
    int field=1;
    for (int i=0;i<numSensors;i=i+1) {
        if (stringComparison(sensors[i],"temp")==true) {
            tempSensorflag=true;
            tempField=field;
            humField=field+1;
            field=field+1;
        } else if (stringComparison(sensors[i],"light")==true) {
            lightSensorflag=true;
            lightField=field;
        } else if (stringComparison(sensors[i],"some other sensor")==true) {
            SomeotherSensorflag=true;
        }
        field=field+1;
    }
    
    while(1)
    {
        
        if (numSensors == 3) {
            
        } else if (numSensors ==2) {
            if (tempSensorflag==true) {
                if (lightSensorflag==true) {
                    getLightReading(&lightData);
                    getTempHumid(&tempData,&humData);
                    sendData3(tempData,tempField,humData,humField,lightData,lightField);
                    sdWrite3(tempData,humData,lightData);
                } else if (SomeotherSensorflag==true) { 
                
                }  
            } else if (lightSensorflag==true) {
                if (SomeotherSensorflag==true) {
                    getLightReading(&lightData);
                    
                    
                }
            }   
        } else {
            if (tempSensorflag==true) {
                getTempHumid(&tempData,&humData);
                sendData2(tempData,tempField,humData,humField);
                sdWrite2(tempData,humData);
            } else if (lightSensorflag==true) {
                getLightReading(&lightData);
                sendData1(lightData,lightField);
                sdWrite1(lightData);
            } else if (SomeotherSensorflag==true) {
                
            }
        }
        wdt_sleep.sleep(BROADCAST_TIME);
    
    }
}