#include "mbed.h"
#include "GPRSInterface.h"
#include "USBSerial.h"
#include "NTPClient.h"
#include "HTTPClient.h"


#define PIN_PWR                 P1_2    //power up gprs module
#define PIN_PWR_KEY             P1_7
#define PIN_TX                  P1_27
#define PIN_RX                  P1_26

#define TS_FEED_ID              25152
#define TS_API                  "GH5ZL0IHZV81017V"

NTPClient ntp;
HTTPClient http;

char* ntpServerUrl = "0.ca.pool.ntp.org";
 
char* thingSpeakUrl = "http://api.thingspeak.com/update";
char* thingSpeakKey = "GH5ZL0IHZV81017V";


char urlBuffer[256];
char timeBuffer[64];

GPRSInterface gprs(PIN_TX,PIN_RX,115200,"live.vodafone.com",NULL,NULL);
DigitalOut power(PIN_PWR);
DigitalOut powerKey(PIN_PWR_KEY);
AnalogIn sensor(P0_12);

USBSerial pc;


void gprsPowerUp(void)
{
    power = 1;
    wait(2);
    power = 0;
    wait(2);
 
    powerKey = 0;
    wait(1);
    powerKey = 1;
    wait(2);
    powerKey = 0;
    wait(3);
}

void settingsChanged(int baud, int bits, int parity, int stop)
{
    const Serial::Parity parityTable[] = {Serial::None, Serial::Odd, Serial::Even, Serial::Forced0, Serial::Forced1};
 
    if (stop != 2) {
        stop = 1;   // stop bit(s) = 1 or 1.5
    }
 
    gprs.serialModem.baud(baud);
    gprs.serialModem.format(bits, parityTable[parity], stop);
}
int main() {
        
    pc.printf("starting...\r\n");
    pc.attach(settingsChanged);
    
    gprsPowerUp();
    
    gprs.init(); //Use DHCP
    // attempt DHCP
    if(gprs.connect()<0) {
        wait(2);
        pc.printf("gprs connect error\r\n");
    }
    pc.printf("GPRS Connect = %s \r\n", gprs.connect());
    pc.printf("IP Address is %s\r\n", gprs.getIPAddress());
    


    
    // get time from ntp
    time_t ctTime;
    Host server(IpAddr(), 123, ntpServerUrl);
    ntp.setTime(server);
    
    while(1)
    {
        // update data here
        ctTime = time(NULL);
        pc.printf("Reading....");
        float temperature = 100*sensor.read();
        
        // format time here
        timeBuffer[0] = 0;
        strftime(timeBuffer, 64, "%Y-%m-%d %H:%M:%S", localtime(&ctTime));
        
        // for debug
        pc.printf("Time: %s, Temperature: %f\r\n", timeBuffer, temperature);
        
        // format url here
        urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?key=%s&field1=%s&field2=%f", thingSpeakUrl, thingSpeakKey, timeBuffer, temperature);
        pc.printf("Request to %s\r\n", urlBuffer);
        
        HTTPText resp;
        HTTPResult res = http.get(urlBuffer, &resp);
        if (res == HTTP_OK)
        {
            pc.printf("Result :\"%s\"\r\n", resp.gets());
        }
        else
        {
            pc.printf("Error %d\r\n", res);
        }
       
        wait(16); // limited by ThingSpeak's API
       
    }

        
    
}
    
