#include "ds1307.h"
#include "mbed.h"
#include "USBSerial.h"

USBSerial pc;

#define SDA    P0_5
#define SCL    P0_4

DS1307 rtc(SDA,SCL); // start DS1307 class and give it pins for connections of the DS1307 device



int sec = 24;       // 24 ssec
int min = 12;       // 12 min
int hours = 13;     // 8 pm
int day = 6;        // Friday
int date = 20;      // April 17
int month = 4;
int year = 15;      // 2025
                   // set time to these values on the ds1307 connected device

DigitalOut POWER(P1_3); //drive low to activate pins

int main() {
    
     POWER.write(1);
    
     rtc.settime( sec, min, hours, day, date, month, year);
     
     while(1){
         
     rtc.gettime( &sec, &min, &hours, &day, &date, &month, &year);
     
     pc.printf("%.2d:%.2d:%.2d\r\n",hours,min,sec);
     
     wait(3);
     }
 }