#include "mbed.h"
#include "DHT.h"
#include "USBSerial.h"
//#include "DHT11.h"

DigitalOut myled(LED1);
//DigitalOut myled2(LED2);

//Virtual serial port over USB
USBSerial serial;

DHT sensor(P1_14,SEN51035P);
//DHT sensor(P1_14,SEN11301P);
//DHT11 sensor(P1_14);
//DHT sensor(A1,SEN51035P);
//DHT sensor(D4,SEN51035P);
//DHT sensor(P1_14,DHT22);

DigitalOut power(P1_3);

int main() {
    int err;
    serial.printf("\r\nDHT Test program");
    serial.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    power.write(0);

    while (1) {
        myled = 1;
        err = sensor.readData();
        if (err == 0) {
            //serial.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            serial.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            //serial.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            serial.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
            //serial.printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
            //serial.printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
        } else
            serial.printf("\r\nErr %i \n",err);
        myled = 0;
        //myled2=1;
        wait(5);
    }
}