#ifndef MBED_JY901_H
#define MBED_JY901_H

#include "mbed.h"
#include "jy901_def.h"

/** jy901 class.
 *  Can measure acceleration, angular Velocity, magnetic and Angle.
 *
 */


class JY901 : public I2C
{
public:

    /**
     * @param sda
     * @param scl
     */
    JY901(PinName sda, PinName scl);

    /** calibrate Gyroscope and Accelerometer
     */
    void calibrateGyroAccel();

    /** calibrate Magnetic
     */
    void calibrateMagnetic();

    /** set height to 0
     */
    void calibrateHeight();

    /** end calibration mode
     */
    void endCalibrate();

    /** calibrate Gyroscope, Accelerometer and Magnetic
     *  set height to 0
     */
    void calibrateAll(int time);

    /** return XaxisAcceleration
     */
    float getXaxisAcceleration();

    /** return YaxisAcceleration
     */
    float getYaxisAcceleration();

    /** return ZaxisAcceleration
     */
    float getZaxisAcceleration();

    /** return XaxisAngularVelocity
     */
    float getXaxisAngularVelocity();

    /** return YaxisAngularVelocity
     */
    float getYaxisAngularVelocity();

    /** return ZaxisAngularVelocity
     */
    float getZaxisAngularVelocity();

    /** return XaxisMagnetic
     */
    float getXaxisMagnetic();

    /** return YaxisMagnetic
     */
    float getYaxisMagnetic();

    /** return ZaxisMagnetic
     */
    float getZaxisMagnetic();

    /** return XaxisAngle
     */
    float getXaxisAngle();

    /** return YaxisAngle
     */
    float getYaxisAngle();

    /** return ZaxisAngle
     */
    float getZaxisAngle();

private:
    char *getdata(char registar);
};

#endif