#include "mbed.h"
#include "ultrasonic.h"

Serial pc(USBTX, USBRX); // tx, rx

 void dist(int distance)
{
    //put code here to happen when the distance is changed
    pc.printf("Distance changed to %dmm\r\n", distance);
    //pc.printf("Distance changed!\n");
    //printf("Distance changed!\r\n");
}

//ultrasonic mu(D8, D9, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
                                        
ultrasonic mu(p30, p29, .1, 1, &dist);    //Set the trigger pin to D30 and the echo pin to D29
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
                                        
//Other sensors can be declared here. 
//ultrasonic nu(pwhatever, pwhatever, .1, 1, &distNu);
//Then we can have multiple independent sensors that each are interrupt driven? 
//I'm worried that I don't understand enough about interrupts and counting that this will work.

int main()
{
    mu.startUpdates();//start measuring the distance
    while(1)
    {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
    }
}
