#include "mbed.h"

DigitalOut LED_GREEN(PA_12);
DigitalOut LED_RED(PD_2);
DigitalOut LED_ENABLE(PC_7);


DigitalIn TRACK_TOP(PA_6);
DigitalIn TRACK_BOTTOM(PA_4);

uint32_t blinkTime_ms = 0;
Timer t;

void green_blink(void){
    if(t.read_ms() - blinkTime_ms > 200){
        LED_RED = 0;
        LED_GREEN = !LED_GREEN;
        blinkTime_ms = t.read_ms();
    }
}
void red_blink(void){
    if(t.read_ms() - blinkTime_ms > 200){
        LED_GREEN = 0;
        LED_RED = !LED_RED;
        blinkTime_ms = t.read_ms();
    }
}


int main() {
    LED_ENABLE = 1; //turning leds on
    t.start();
    blinkTime_ms = t.read_ms();
    
    
    while(1) {
        
        if(TRACK_TOP == 0 && TRACK_BOTTOM == 0){    //OM TOMT I SEDELPATH BLINKAR DET GRÖNT
            green_blink();
        }else if(TRACK_TOP == 1 && TRACK_BOTTOM == 0){       //OM ÖVRE SENSORN I SEDELPATH ÄR TÄCKT LYSER DET RÖTT
            LED_RED = 1;
            LED_GREEN = 0;
        }else if(TRACK_TOP == 0 && TRACK_BOTTOM == 1){       //OM UNDRE SENSORN I SEDELPATH ÄR TÄCKT LYSER DET GRÖNT
            LED_RED = 0;
            LED_GREEN = 1;
        }else{                      //OM BÅDA SENSORERNA I SEDELPATH ÄR TÄCKTA BLINKAR DET RÖTT
            red_blink();
        }
        

    }
}


