#include "mbed.h"
#include "rtos.h"
#include "C12832.h"
#include "MMA7660.h"




//FINITE STATE MACHINE EVENTS
#define NO_EVENT 0
#define TIME_OUT 1
#define BUTTON_PRESS 2
#define TILT 3
#define PUSH 4

//STATES
#define STATE_0 0
#define STATE_1 1
#define STATE_2 2

//Mutex
Mutex LED_RGB;

//pass event via message queue
typedef struct {
    int    event;   /* AD result of measured voltage */
} message_t;

MemoryPool<message_t, 16> mpool;
Queue<message_t, 16> queue;

//Digital input
//DigitalIn coin(p14);
InterruptIn button(p14);

//Analog input
AnalogIn push(p19);

//Setup hardware
MMA7660 MMA(p28, p27);
C12832 lcd(p5, p7, p6, p8, p11);

//RGB LEDs
DigitalOut led_R(p23); //LED RGB red
DigitalOut led_G(p24); //LED RGB green
DigitalOut led_B(p25); //LED RGB Blue

//leds for debug
DigitalOut led4(LED4); //LED
DigitalOut led3(LED3); //LED
DigitalOut led2(LED2); //LED

//Global varible
int button_press=0;


void timeout_event(void const *n)
{

    //event via a message queue
    message_t *message = mpool.alloc();
    message->event = TIME_OUT;
    queue.put(message);

    led4 =  !led4;

}


void button_event_thread(void const *argument)
{

    while (true) {

        if (button_press == 1) {

            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = BUTTON_PRESS;
            queue.put(message);

            led3 = !led3;
            button_press = 0;
            Thread::wait(500);
        }



    }
}


void tilt_event_thread(void const *argument)
{
    float tilt_value_Y = MMA.y();
    float tilt_value_X = MMA.x();
    while (true) {

        //debouce delay for switch


        if (tilt_value_Y <= MMA.y()-0.2 ^ tilt_value_Y >= MMA.y()+0.2 ) {

            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = TILT;
            queue.put(message);

            led3 = !led3;
            Thread::wait(1500);
            tilt_value_Y = MMA.y();
        }


    }


}

void push_event_thread(void const *argument)
{
    float push_value = push.read();
    while (true) {

        //debouce delay for switch

        if (push_value >= push.read()- 0.15 ^ push_value <= push.read()+ 0.15 ) {
            //event via a message queue
            message_t *message = mpool.alloc();
            message->event = PUSH;
            queue.put(message);
            led3 = !led3;
            Thread::wait(1000);
            push_value = push.read();
        }
    }


}
void flash_led_thread(void const *argument)
{
    while (true) {
        Thread::signal_wait(0x1);

        for (int i=0; i<=20; i++) {
            LED_RGB.lock();
            led_R = !led_R;
            LED_RGB.unlock();
            Thread::wait(100);
        }
        LED_RGB.lock();
        led_R = 1;
        LED_RGB.unlock();
    }

}



void Button_Inter()
{
//Flash_LED_Thread.signal_set(0x1);

    button_press=1;

}

int main (void)
{

//Thread fsm(fsm_thread);
    Thread button_event(button_event_thread);
    Thread tilt_event(tilt_event_thread);
    Thread push_event(push_event_thread);
    Thread Flash_LED_Thread(flash_led_thread);
    RtosTimer timer(timeout_event, osTimerPeriodic, (void *)0);

//Interrupts
    button.rise(&Button_Inter);

    int state = STATE_0;

    LED_RGB.lock();
    led_R=1;
    led_G=1;
    led_B=1;
    LED_RGB.unlock();

    if (MMA.testConnection())   //setup accler

        //start timer with a 2 sec timeout
        timer.start(2000);

    while (true) {


        switch(state) {
            case STATE_0:
                osEvent evt = queue.get();
                if (evt.status == osEventMessage) {
                    message_t *message = (message_t*)evt.value.p;


                    if(message->event == BUTTON_PRESS) {
                        LED_RGB.lock();
                        led_G=0;
                        led_R=1;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Enter");
                        state = STATE_1;
                    }
                    if(message->event == PUSH) {
                        LED_RGB.lock();
                        led_G=1;    //off
                        led_R=0;    //on
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin push");
                        state = STATE_0;
                    }
                    if(message->event == TILT) {
                        LED_RGB.lock();
                        led_G=1;
                        led_R=1;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("STOP");
                        lcd.locate(0,10);
                        lcd.printf("Please Insert Coin");
                        Flash_LED_Thread.signal_set(0x1);
                        state = STATE_2;
                    }
                    if(message->event == TIME_OUT) {
                        LED_RGB.lock();
                        led_G=1;
                        led_R=0;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Hello");
                        state = STATE_0;
                    }
                    mpool.free(message);
                }

                timer.start(2000);

                break;

            case STATE_1:

                evt = queue.get();
                if (evt.status == osEventMessage) {
                    message_t *message = (message_t*)evt.value.p;


                    if(message->event == BUTTON_PRESS) {
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Thanks");
                        state = STATE_1;
                    }
                    if(message->event == PUSH) {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Hello");
                        state = STATE_0;
                    }

                    mpool.free(message);
                }

                timer.start(2000);


                break;

            case STATE_2:

                evt = queue.get();
                if (evt.status == osEventMessage) {
                    message_t *message = (message_t*)evt.value.p;

                    if(message->event == BUTTON_PRESS) {
                        LED_RGB.lock();
                        led_G=0;
                        led_R=1;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Enter");
                        state = STATE_1;

                    }
                    if(message->event == TILT) {
                        lcd.cls();
                        lcd.locate(0,0);
                        lcd.printf("STOP");
                        lcd.locate(0,10);
                        lcd.printf("Please Insert Coin");
                        state = STATE_2;
                        Flash_LED_Thread.signal_set(0x1);
                    }
                    if(message->event == TIME_OUT) {
                        LED_RGB.lock();
                        led_R=0;
                        led_G=1;
                        LED_RGB.unlock();
                        lcd.cls();
                        lcd.locate(0,2);
                        lcd.printf("Insert Coin");
                        state = STATE_0;
                    }
                    mpool.free(message);
                }

                timer.start(2000);

                break;



        }//End of switch

        //toggle led for local testing
        //led2= !led2;

    }//end of while(1)


}