#include "mbed.h"
#include "rtos.h"

Semaphore two_slots(2);                         //Setup the use of two semaphores

void test_thread(void const *name) {            //setup thread function 
    while (true) {
        two_slots.wait();                       //Wait to get a semaphore to use the 
        printf("%s\n\r", (const char*)name);    //when have semaphore printf on serial of thread number
        Thread::wait(1000);                     //thread wait
        two_slots.release();                    //Release semaphore back to RTOS
    }
}

int main (void) {
    Thread t2(test_thread, (void *)"Th 2");     //start thread
    Thread t3(test_thread, (void *)"Th 3");     //start thread
    
    test_thread((void *)"Th 1");                //function call in main thread
}
