#include "mbed.h"                                           //Include the mbed.h file
#include "rtos.h"                                           //Include the rtos.h file

Mutex stdio_mutex;                                          //Setup the mutex

void notify(const char* name, int state) {                  //function and passes data NAME and STATE to the function
    stdio_mutex.lock();                                     //mutex lock stdio_mutex 
    printf("%s: %d\n\r", name, state);                      //read name and state and print them on serial
    stdio_mutex.unlock();                                   //mutex unlock stdio_mutex 
}

void test_thread(void const *args) {                        //Thread and function, pass data to the thread/function
    while (true) {                                          //Super loop
        notify((const char*)args, 0);                       //function call, passes number and toggles data to the function
        Thread::wait(1000);                                 //Thread wait 1 sec
        notify((const char*)args, 1);                       ////function call, pass two data to the function
        Thread::wait(1000);                                 //Thread wait 1 sec
    }                                                       //end super loop
}                                                           //end function

int main() {
    Thread t2(test_thread, (void *)"Th 2");                 //start thread t2
    Thread t3(test_thread, (void *)"Th 3");                 //start thread t3
    
    test_thread((void *)"Th 1");                            //function call
}                                                           //end main
