#include "mbed.h"                       //Include the mbed.h file   
#include "rtos.h"                       //include the RTOS.h file
#include "LM75B.h"
#include "C12832.h"

C12832 lcd(p5, p7, p6, p8, p11);

LM75B sensor(p28,p27);
Serial pc(USBTX,USBRX);

float Temp_Value;
     
PwmOut spkr(p26);
PwmOut LED_red(p23);
PwmOut LED_blue(p25);

DigitalOut led1(LED1);                  //Setup LED1 to the varible name led1
DigitalOut led2(LED2);                  //Setup LED2 to the varible name led2

Mutex Temp_Mutex;
 
 
void Tempature_Senor(void const *args) {   //Function or the thread to be called

     //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");

        while (1) {
            lcd.cls();
            lcd.locate(0,3);
            lcd.printf("Temp = %.3f\n", (float)sensor);
            Temp_Mutex.lock();
            Temp_Value = (float)sensor;
            Temp_Mutex.unlock();
            wait(1.0);
        }

    } else {
        error("Device not detected!\n");
    }                                 //End Super loop
}  
 
void Speaker(void const *args) {   //Function or the thread to be called
    while (true) {                      //Super loop
        spkr.period(1.0/5000);
        spkr = 0.25;                           
        Thread::wait(800);  
        spkr.period(1.0/3000);   
        spkr = 0.25;                        
        Thread::wait(800);             
    }                                   //End Super loop
}  
 
void led_R_B_flash(void const *args) {   //Function or the thread to be called
    while (true) {                      //Super loop
    
        LED_red = 0.5;     
        LED_blue = 1;                        
        Thread::wait(800); 
        LED_red = 1;     
        LED_blue = 0.5;                        
        Thread::wait(800);             
    }                                   //End Super loop
}                                       //End Function / thread
 
int main() {                            //Main
    float local_Temp_V=0;
    Thread thread_Temp(Tempature_Senor);
    Thread thread_LED_Flash(led_R_B_flash);       
    Thread thread_Speaker_Sound(Speaker);  
    
        while (1) {
            Temp_Mutex.lock();
            local_Temp_V = Temp_Value;
            Temp_Mutex.unlock();
            printf("Temp = %.3f\n", local_Temp_V );           
            wait(1.0);
        }

    
}                                       //End main
