#include "datetime.h"
#include "rtc_api.h"
#include "mbed.h"

void SetDateTime
(int           year = 2015
,int           mon = 5
,int           day = 26
,int           hour = 10
,int           min = 0
,int           sec = 0
)
{
  //  struct     tm Clock;
    Clock.tm_year = year - 1900;
    Clock.tm_mon  = mon;
    Clock.tm_mday = day;
    Clock.tm_hour = hour;
    Clock.tm_min  = min;
    Clock.tm_sec  = sec;
    time_t epoch = mktime(&Clock);
    if (epoch == (time_t) -1) {
        error("Error in clock setting\r\n");        
    }
    set_time(epoch);
}   

void ShowDateTime()
{
    char       str[32];
    time_t     seconds = time(NULL);
    struct tm *gpsd = localtime(&seconds);
    struct tm *tminfo = localtime(&seconds);
 
    strftime(str, 32, "%F,%T", tminfo);
    //printf("RTC: %s\r\n", str);
    printf("%02d/%02d/%02d,", gpsd->tm_mon, gpsd->tm_mday, gpsd->tm_year+1900);
    printf("%02d:%02d:%02d ", gpsd->tm_hour, gpsd->tm_min, gpsd->tm_sec);  
}
 