/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    ( C )2014 Semtech

Description: Contains the callbacks for the IRQs and any application related details

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __MAIN_H__
#define __MAIN_H__
#include "GPS.h"
 
/*!
 * @brief Function executed on CAD Done event
 */
void OnCadDone( void );

char* itoa(int val, int base);
unsigned int randomSeed(void);
void start_ping_pong(void);
void ping_pong(void);
void start_hello(void);
void hello(void);
void check_gps(void);
int get_kbd_str(char* buf, int size);
void console_chat();
void console();
 
/*
 *  Global variables declarations
 */
extern Serial pc;
 
#define BUFFER_SIZE                                     256        // Define the payload size here

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
extern DigitalOut led;
#else
extern DigitalOut led;
#endif
 
 
extern GPS gpsd;
extern uint8_t PingMsg[];
extern uint8_t PongMsg[];
extern uint8_t HelloMsg[];
extern uint16_t BufferSize;
extern uint8_t BufferTx[];
extern uint8_t BufferRx[];
extern float Frequency;
extern int TxPower;
extern int Bandwidth;
extern int SpreadingFactor;
extern int CodingRate;
extern bool isMaster;
extern bool AlwaysMaster;
extern bool AlwaysSlave;
extern bool rxTimeout;
extern char pcbuf[];
extern bool ackRcvd;
extern bool gpsEnabled;
extern int txLen;
extern int16_t RssiValue;
extern int8_t SnrValue;
#define PCBUF_SIZE 64

typedef enum {
    APP_NONE = 0,
    APP_PING,
    APP_CHAT,
    APP_HELLO,
    APP_CONSOLE,
    APP_GPS
} app_e;

extern app_e app;

#endif // __MAIN_H__