#include "mbed.h"
#include "GPS.h"
#include "main.h"
#include "TSISensor.h"
#include "SDFileSystem.h"
 
Serial pc(USBTX, USBRX);
GPS gpsd(PTE20, PTE21);
 // frdm-kl25z sd card connections
 // ------------------------------------------------
 // Header -- kl25z -- SD/MMC          
 // J2-8   -- PTD2  -- MOSI
 // J2-6   -- PTD0  -- CS
 // J9-12  -- GND   -- Vss (GND) 
 // J9-4   -- P3V3  -- Vdd (+3.3v)
 // J2-12  -- PTD1  -- SCK
 // J9-14  -- GND   -- Vss (GND)
 // J2-10  -- PTD3  -- MISO
 
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); // MOSI, MISO, SCK, CS
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
//DigitalOut blue(LED_BLUE);  don't use the blue led, due to a board error, writing to the blue led kills spi
bool debug;
 
bool gpsEnabled = true;
 
int main()
{
    bool debug=false;
    bool logOpened=false;
    char logFile[128];
    char directory[]="/sd/gps_data";
    char c;
    FILE *fp;
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 1000; //refresh time in ms
    TSISensor tsi;   // touch slider
    int write_count=0;
    pc.baud(9600);
    
    red = 1;
    green = 1;
    pc.printf("Touch slider to start application\r\n");
    while(1) {
        green = 1;   // turn led off
        wait_ms(200);
        green = 0;  // turn led on
        wait_ms(200);
        if (tsi.readPercentage())
            break;
    }
    green = 1;
  
    gpsd.setBaud(9600);
    gpsd.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA); 
    gpsd.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    gpsd.sendCommand(PGCMD_ANTENNA);
    gpsd.day=01;
    gpsd.month=01;
    gpsd.year=15;
    gpsd.hour=1;
    gpsd.minute=1;
    gpsd.seconds=1;
    refresh_Timer.start();  //starts the clock on the timer
    //Mount the filesystem
    sd.mount();
    mkdir(directory, 0777);
    pc.printf("Starting GPS App\r\n");
    while (1)
    {
        c = gpsd.read();   //queries the GPS
        if (debug)
        {
            if (c) { 
                printf("%c", c);  //this line will echo the GPS data if not paused
                continue;
            }
        }
        
        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( gpsd.newNMEAreceived() ) {
            if ( !gpsd.parse(gpsd.lastNMEA()) ) {
                continue;   
            }    
        }
               
        //check if enough time has passed to warrant printing GPS info to screen
        //note if refresh_Time is too low or pc.baud is too low, GPS data may be lost during printing
        if (refresh_Timer.read_ms() >= refresh_Time) 
        {
            if (gpsd.fix) {
                // got a gps fix
                
                // is the log file open? if not, open it
                if ( !logOpened )
                {
                    logOpened = true;
                    // create a log file name with the current date/time stamp
                    sprintf(logFile, "%s%s%02d_%02d_20%02d_%02d_%02d_%02d.csv", directory,"/gps_",gpsd.day,gpsd.month,gpsd.year,gpsd.hour,gpsd.minute,gpsd.seconds);
                    sd.mount();
                    fp = fopen(logFile, "w");
                    if(fp == NULL) {
                        // retry
                        wait_ms(500);
                        fp = fopen(logFile, "w");
                        if (fp == NULL)
                            error("Could not open file %s for writing\r\n",logFile);
                    }
                    else
                    {
                        pc.printf("Opened log file %s\r\n",logFile);
                    }
                    // write the log file header
                    fprintf(fp,"# date,time,raw timestamp,latitude,longitude\r\n");
                }
               
                pc.printf("Date: %02d/%02d/20%02d ", gpsd.month, gpsd.day, gpsd.year);
                pc.printf("%02d:%02d:%02d ", gpsd.hour, gpsd.minute, gpsd.seconds);   
                pc.printf("Rawdate: %7.0f ",gpsd.timef);
                //pc.printf("Fix: %d ", (int) gpsd.fix);
                //pc.printf("Quality: %d ", (int) gpsd.fixquality);
                //pc.printf("Loc: %5.2f%c, %5.2f%c ", gpsd.latitude, gpsd.lat, gpsd.longitude, gpsd.lon);
                pc. printf("Loc: %5.7f, %5.7f ", gpsd.lat_deg, gpsd.lon_deg);
                //pc.printf("Speed: %5.2f knots ", gpsd.speed);
                //pc.printf("Angle: %5.2f ", gpsd.angle);
                //pc.printf("Altitude: %5.2f ", gpsd.altitude);
                pc. printf("Sat: %d\r\n", gpsd.satellites);
                
                //red = 1;  // turn led off
                green = 0;  // turn led on
                //wait_ms(100);
                // keep the log files small by keeping track of write_count.
                // when write_count exceeds a threshold, close the log file.
                // a new log file will be openeded at the start of the next loop.
                if (write_count < 1000)
                {
                    // write to the current log file
                    fprintf(fp,"%02d/%02d/20%02d,", gpsd.month, gpsd.day, gpsd.year);
                    fprintf(fp,"%02d:%02d:%02d,", gpsd.hour, gpsd.minute, gpsd.seconds);  
                    fprintf(fp,"%7.0f,",gpsd.timef);
                    fprintf(fp,"%5.7f,%5.7f", gpsd.lat_deg, gpsd.lon_deg);
                    fprintf(fp,"\r\n");
                    fflush(fp);
                    f_sync((FIL*)fp); 
                    fclose(fp);
                    fp = fopen(logFile, "a");
                    //wait_ms(100);
                    if(fp == NULL) 
                    {    
                        // retry
                        wait_ms(500);
                        fp = fopen(logFile, "a");
                        if (fp == NULL)
                            error("Could not open file for writing 2\r\n");
                    }
                    //else
                    //    pc.printf("file closed then reopened\r\n");
                    write_count++;
                   
                }
                else
                {
                    // close the current log file
                    fclose(fp); 
                    write_count = 0;
                    logOpened = false;
                    //Unmount the filesystem
                    sd.unmount();
                }
                 
            }
            else
            {
                pc.printf("Waiting for GPS FIX\r\n");
                red = 0; // turn led on
            }
          
            // restart the timer for the gps print loop  
            refresh_Timer.reset();    
        }
        else
        {
            //red = 0; // turn led on
            green = 1; // turn green led off
            // check the slider.  if touched, close the log file and wait for another slider touch
            if (tsi.readPercentage())
            {
                // close the current log file
                fclose(fp); 
                write_count = 0;
                logOpened = false;
                pc.printf("Closed log file %s\r\n", logFile);
                pc.printf("Touch slider to continue application\r\n");
                while (1)
                {
                   
                    green = 1;   // turn led off
                    wait_ms(200);
                    green = 0;  // turn led on
                    wait_ms(200);
                    // break of of the loop if the slider is touched
                    if (tsi.readPercentage())
                    {
                        green = 1;
                        red = 1;
                        break;
                    }
                    
                } // end while 1 for slider
            } // end if tsi read      
        } // end else refresh timer            
   
    }

            
  
}
