/**
 * Test program for configuration file interface class (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */
#include "mbed.h"
#include "ConfigFile.h"
#include "SDFileSystem.h"
  
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX,USBRX);
ConfigFile cfg;
 
/**
 * View the list.
 */
void viewlist(void) {
    /*
     * If you need to check all parameters.
     */
    const int cnt = cfg.getCount();
    char buf_key[BUFSIZ];
    char buf_value[BUFSIZ];
    for (int i = 0; i < cnt; i++) {
        if (cfg.getKeyAndValue(i, buf_key, sizeof(buf_key), buf_value, sizeof(buf_value))) {
            printf("No.%3d:'%s'='%s'\n", i, buf_key, buf_value);
        } else {
            printf("No.%3d:Failure to get a configuration.\n", i);
        }
    }
}

/**
 * ==================================================
 * Input file (input.cfg)
 * ==================================================
 * #
 * # Configuration file for mbed.
 * #
 *
 * MyKey1=This is a value for key1.
 * MyKey2=Value 2
 *
 * Message1 = This is a test message no.1
 *  Message2 = This is a test message no.2
 *   Message3 = This is a test message no.3
 *
 * ==================================================
 * Output file (output1.cfg)
 * ==================================================
 * MyKey1=This is a value for key1.
 * MyKey2=Value 2
 * Message1 = This is a test message no.1
 *  Message2  =  This is a test message no.2
 *   Message3   =   This is a test message no.3
 *
 * ==================================================
 * Output file (output2.txt)
 * ==================================================
 * # This is a configuration file for my application.
 * ABC=123
 * DEF=456
 *
 * ==================================================
 * Console output
 * ==================================================
 * 'MyKey1'='This is a value for key1.'
 * 'MyKey2'='Value 2'
 * 'Message1 '=' This is a test message no.1'
 * ' Message2  '='  This is a test message no.2'
 * '  Message3   '='   This is a test message no.3'
 *
 */
int main() {

    char *key1 = "MyKey1";
    char *key2 = "MyKey2";
    char *key3 = "Message1 ";
    char *key4 = " Message2  ";
    char *key5 = "  Message3   ";
    char value[BUFSIZ];
    
    pc.baud(9600);
    
    printf("config file test!\r\n");
    
    sd.mount();
    int rc=mkdir("/sd/config", 0777);
    printf("rc from mkdir is %d\r\n",rc);
    wait(1);
    FILE *fp = fopen("/sd/config/input.cfg", "r");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    else
        printf("file opened for writing\r\n");
    /*
     * Read a configuration file from a mbed.
     */
     
    cfg.read("/sd/config/input.cfg");

    /*
     * Read a configuration value.
     */
    if (cfg.getValue(key1, &value[0], sizeof(value))) {
        printf("'%s'='%s'\r\n", key1, value);
    }

    if (cfg.getValue(key2, &value[0], sizeof(value))) {
        printf("'%s'='%s'\r\n", key2, value);
    }

    if (cfg.getValue(key3, &value[0], sizeof(value))) {
        printf("'%s'='%s'\r\n", key3, value);
    }

    if (cfg.getValue(key4, &value[0], sizeof(value))) {
        printf("'%s'='%s'\r\n", key4, value);
    }

    if (cfg.getValue(key5, &value[0], sizeof(value))) {
        printf("'%s'='%s'\r\n", key5, value);
    }

    /*
     * Write a configuration file.
     */
    cfg.write("/sd/config/output1.cfg");
    pc.printf("wrote config file 1\r\n");

    /*
     * Remove all configurations.
     */
    cfg.removeAll();

    /*
     * Write a configuration value.
     */
    cfg.setValue("ABC", "123");
    cfg.setValue("DEF", "456");

    /*
     * Write a configuration file.
     */
    cfg.write("/sd/config/output2.cfg", "# This is a configuration file for my application.");
    pc.printf("wrote config file 2\r\n");

    fclose(fp);
    sd.unmount();
    while (1) {
    }
}
