#include "mbed.h"
#include "sx1276-hal.h"
#include "main.h"
#include "debug.h"
// radfta #include "vt100.h"
#include "serial_api.h"

void start_ping_pong(void)
{
    //char pcbuf[64];
    int len = get_kbd_str(pcbuf, PCBUF_SIZE);
    if (len < 0) {
        //xctrl.cls();
        fflush(stdout);
        Radio.Rx( RX_TIMEOUT_VALUE );
        Radio.Tx( TX_TIMEOUT_VALUE );
        Radio.Sleep( );
        debug("Ping pong app ended\r\n");
        app = APP_CONSOLE;
        // red = 1; green = 1; blue = 1;
        print_help();
        printf("> ");
        fflush(stdout);
        return;
    }
    else
    {        
        ping_pong();
    }
}

void ping_pong(void)
{
    static uint8_t i;
    // static bool isMaster = true;
    // radfta vt100 ctrl;
    static int xmit_count = 0;
       
    //ctrl.cls();
  
    strcpy((char *)PingMsg,"PING");
    strcpy((char *)PongMsg,"PONG");
   
 
    switch( State )
    {
        case RX:
            //ctrl.cls();
            led = !led;
            if( isMaster == true )
            {
                //debug("master is true \r\n");
                if( BufferSize > 0 )
                {
                    if( strncmp( ( const char* )BufferRx, ( const char* )PongMsg, 4 ) == 0 )
                    {
                        //debug( "...Pong\r\n" );
                        debug( "master mode, ...received %s, ",  BufferRx );
                        // Send the next PING frame   
                        ++xmit_count;
                        strcpy((char *)PingMsg, "PING_");
                        strcat((char *)PingMsg, itoa(xmit_count,10));
                        strcpy( ( char* )BufferTx, ( char* )PingMsg );
                        debug( "send %s\r\n", BufferTx );
                        // We fill the buffer with numbers for the payload 
                        int msgLen=strlen((char *)BufferTx);
                        for( i = msgLen; i < BufferSize; i++ )
                        {
                            BufferTx[i] = i - msgLen;
                        }
                        // wait_ms( 10 ); 
                        wait_ms(100);
                        // ctrl.cls();
                        Radio.Send( BufferTx, BufferSize );
                    }
                    else if( strncmp( ( const char* )BufferRx, ( const char* )PingMsg, 4 ) == 0 )
                    { // A master already exists then become a slave
                       
                        if (AlwaysMaster)
                            return;
                        isMaster = false;
                        // Send the next PONG frame    
                        ++xmit_count;
                        debug( "master mode, become a slave, ...received %s, ", BufferRx );
                        strcpy((char *)PongMsg, "PONG_");
                        strcat((char *)PongMsg, itoa(xmit_count,10));   
                        strcpy( ( char* )BufferTx, ( char* )PongMsg );
                        debug( "send %s\r\n", BufferTx );
                        // We fill the buffer with numbers for the payload 
                        int msgLen=strlen((char *)BufferTx);
                        for( i = msgLen; i < BufferSize; i++ )
                        {
                            BufferTx[i] = i - msgLen;
                        }
                        wait_ms( 10 ); 
                        Radio.Send( BufferTx, BufferSize );
                    }
                    else // valid reception but neither a PING or a PONG message
                    {    // Set device as master an start again
                        if (AlwaysSlave == false)
                            isMaster = true;
                        debug( "...received %s, but it was not a PING or a PONG\r\n", BufferRx );
                        Radio.Rx( RX_TIMEOUT_VALUE );
                    }    
                }
            }
            else
            {
                //debug("master is false \r\n");

                if( BufferSize > 0 )
                {
                    if( strncmp( ( const char* )BufferRx, ( const char* )PingMsg, 4 ) == 0 )
                    {
                        //red = !red;
                       // red = !red; green = 1; blue = 1;
                        // ctrl.cls();
                        debug( "slave mode, ...received %s, ", BufferRx );

                        // Send the reply to the PING string
                        ++xmit_count;
                        strcpy((char *)PongMsg, "PONG_");
                        strcat((char *)PongMsg, itoa(xmit_count,10));   
                        strcpy( ( char* )BufferTx, ( char* )PongMsg );
                        debug( "send %s \r\n", BufferTx );
                        // We fill the buffer with numbers for the payload 
                        int msgLen=strlen((char *)BufferTx);
                        for( i = msgLen; i < BufferSize; i++ )
                        {
                            BufferTx[i] = i - msgLen;
                        }
                        wait_ms( 10 );  
                        Radio.Send( BufferTx, BufferSize );
                    }
                    else // valid reception but not a PING as expected
                    {    // Set device as master and start again
                        debug( "...received %s, but was expecting %s\r\n", BufferRx, (const char *)PingMsg );
                        if (AlwaysSlave == false)
                            isMaster = true;
                        Radio.Rx( RX_TIMEOUT_VALUE );
                    }    
                }
            }
            State = LOWPOWER;
            break;
        case TX:    
            // red = !red;
         //   red = !red; green = 1; blue = 1;
            int i;
    
            if( isMaster == true )  
            {
                //x ctrl.cls();
               //x ctrl.putStr( 1,1,"Ping...\r\n" );
                 printf("Ping..\r\n");
            }
            else
            {
                
                //x ctrl.cls();
               // ctrl.putStr( 1,1,"Pong...\r\n" );
                printf("Pong..\r\n");
            }
         //   Radio.Tx( TX_TIMEOUT_VALUE );
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_TIMEOUT:
            if( isMaster == true )
            {
                // Send the next PING frame
                ++xmit_count;
                strcpy((char *)PingMsg, "PING_");
                strcat((char *)PingMsg, itoa(xmit_count,10));
                strcpy( ( char* )BufferTx, ( char* )PingMsg );
                debug( "master mode, rx timeout, send %s\r\n", BufferTx );
                int msgLen=strlen((char *)BufferTx);
                #if 0
                for( i = msgLen; i < BufferSize; i++ )
                {
                    BufferTx[i] = i - msgLen;
                }
                #else
                BufferSize = msgLen;
                #endif
        
                /* initialize random seed: */
                srand ( randomSeed() );
                // generate a random wait time
                int mywait = (5*(rand()%10 +1));
                debug("wait %d ms before sending\r\n", mywait);
                wait_ms(mywait);
                Radio.Send( BufferTx, BufferSize );
                // use the random wait time to occasionaly switch modes.  
                // this helps break out of endless cycles when both sides are
                // in master mode 
                if ((mywait % 10) == 0)
                {
                  if (AlwaysMaster == false)
                    isMaster = false;
                }
               
            }
            else
            {   /* initialize random seed: */
                debug("rx timeout in slave mode\r\n");
                srand ( randomSeed() );
                // generate a random wait time
                int mywait = (5*(rand()%10 +1));
                if ((mywait % 10) == 0)
                {
                    if (AlwaysSlave == false)
                    {
                        isMaster = true;
                        debug("switch to master mode\r\n");
                    }
                }
                Radio.Rx( RX_TIMEOUT_VALUE );  
            }             
            State = LOWPOWER;
            break;
        case RX_ERROR:
            // We have received a Packet with a CRC error, send reply as if packet was correct
            if( isMaster == true )
            {
                // Send the next PING frame
                ++xmit_count;
                strcpy((char *)PingMsg, "PING_");
                strcat((char *)PingMsg, itoa(xmit_count,10));
                strcpy( ( char* )BufferTx, ( char* )PingMsg );
                debug( "master mode, rx error, send %s\r\n", BufferTx );
                int msgLen=strlen((char *)BufferTx);
                for( i = msgLen; i < BufferSize; i++ )
                {
                    BufferTx[i] = i - msgLen;
                }
                wait_ms( 10 );  
                Radio.Send( BufferTx, BufferSize );
            }
            else
            {
                // Send the next PONG frame
                ++xmit_count;
                strcpy((char *)PongMsg, "PONG_");
                strcat((char *)PongMsg, itoa(xmit_count,10));
                strcpy( ( char* )BufferTx, ( char* )PongMsg );
                debug( "slave mode, rx error, send %s\r\n", BufferTx );
                int msgLen=strlen((char *)BufferTx);
                for( i = msgLen; i < BufferSize; i++ )
                {
                    BufferTx[i] = i - msgLen;
                }
                //wait_ms( 10 ); 
                wait_ms(100); 
                // ctrl.cls();
                Radio.Send( BufferTx, BufferSize );
            }
            State = LOWPOWER;
            break;
        case TX_TIMEOUT:
            debug("tx timeout\r\n");
            Radio.Tx( TX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            static int j=0;
            //if ((j%100000) == 0)
            if ((j%10000) == 0)
            {
              debug("low power state %d\r\n", j);
              j=1;
            }
            else
                j++;
            // wait_ms( 250 );  
            wait_ms (5);
            break;
        default:
            debug("state is set to low power\r\n");
            State = LOWPOWER;
            break;
    }    
}
