#include "mbed.h"
#include "sx1276-hal.h"
#include "main.h"
#include "debug.h"
//radfta #include "vt100.h"
#include "serial_api.h"
 
void console_chat()
{
    //char pcbuf[64
    if (ackRcvd == false)
    {
        check_rx_chat();
        return;    
    }
    else
    {
        printf("\r\n");
        printf("-chat-> ");    
        fflush(stdout);   
    }
    
    int i, len = get_kbd_str(pcbuf, PCBUF_SIZE);
    if (len < 0) {
        // ctrl.cls();
        printf("Console chat ended\r\n");
        print_help();
        printf("> ");
        app = APP_CONSOLE;
        return;
    } 
    else
    {

 
        if (len > 0)
        {
             for (i = 0; i < len; i++)
                BufferTx[i] = pcbuf[i];
            BufferTx[len] = '\0';
 
           // debug( "\r\nchat send %s, len is %d, state is %d \r\n", BufferTx, len, State );
            // wait_ms(20);
        
            
            //State = LOWPOWER;
            //Radio.Sleep( );
            ackRcvd = false;
            txLen = len;
            Radio.Send( BufferTx, txLen );
        }    
              

 
    }
}

void print_help()
{
                //radfta ctrl.cls();
                printf("     Radio Utilities    \r\n");
                printf("-----------------------------------------\r\n");
                print_status();
                printf("M         set mode to Master\r\n");
                printf("S         set mode to Slave\r\n");
                //printf("B         set mode to Bi-directional\r\n");
                printf("P         Start ping pong application\r\n");
                printf("C         Start console chat application\r\n");
                printf("H         Start hello exchange\r\n");
                printf("G         Start GPS exchange\r\n");


                //printf("i           radio_init\r\n");
                //printf("h           hw_reset\r\n");
                //printf("tx[%%d]    transmit\r\n");
                //printf("rx          receive\r\n");   
                //printf("C           toggle crcOn\r\n");
                //printf("R           read all registers\r\n");
                printf("op[%%d]    get/set output power. op14 -> 14dBm...\r\n");
                //printf("d[0-5]      change DIO pin assignment\r\n");
                printf("frf[%%f}   get/set operating frequency (MHz). frf915 -> 915MHz, fr413 ->413MHz....\r\n");
                //printf("pl[%%d]    LORA get/set RegPayloadLength\r\n");
                printf("cr[1234]  LORA set coding rate. cr1 -> 4/5, cr2 -> 4/6, cr3 -> 4/7 cr4 ->4/8  \r\n");
                printf("bw[%%d]    LORA get/set bandwidth. bw0 -> 125KHz, bw1 -> 250KHz, bw2 -> 500KHz \r\n");
                printf("sf[%%d]    LORA get/set spreading factor. sf7-sf12\r\n");
                //printf("T           LORA toggle TxContinuousMode\r\n");
                //printf("hp[%%d]    LORA get/set hop period\r\n");
                //printf("hm          LORA toggle explicit/explicit header mode\r\n");

                printf("?         Display help\r\n");
                printf(".         Display configuration\r\n");
}

void console()
{
    int len;
  //  char pcbuf[64];

             
    len = get_kbd_str(pcbuf, PCBUF_SIZE);

    if (len < 0) {
        // ctrl.cls();
        Radio.Sleep( );
        debug("Console configuration ended\r\n");
        app = APP_CONSOLE;
        print_help();
        printf("> ");
        fflush(stdout);
        return;
    }
    
    printf("\r\n");
    if (len == 1) {
        switch (pcbuf[0]) {
            case '?':
                print_help();
                break;
            case '.':
                print_status();
                break;
            case 'M':
                AlwaysMaster=true;
                isMaster = true;
                AlwaysSlave=false;
                break;
             case 'S':
                AlwaysSlave=true;
                isMaster = false;
                AlwaysMaster=false;
                break;    
             case 'B':
                AlwaysSlave=false;
                isMaster = true;
                AlwaysMaster=false;
                break;        
             case 'G':
                // radfta ctrl.cls();
                debug("Starting GPS exchange\r\n");
                gpsEnabled = true;
                fflush(stdout);
                app = APP_HELLO;
                // radfta gpsd.l_latitude = gpsd.l_longitude = gpsd.r_latitude = gpsd.r_longitude = 0;
                Radio.Rx( RX_TIMEOUT_VALUE );
                Radio.Tx( TX_TIMEOUT_VALUE );
                break;    
            case 'P':
                // radfta ctrl.cls();
                debug("Starting ping pong app\r\n");
                fflush(stdout);
                app = APP_PING;
                // radfta gpsd.l_latitude = gpsd.l_longitude = gpsd.r_latitude = gpsd.r_longitude = 0;
                Radio.Rx( RX_TIMEOUT_VALUE );
                Radio.Tx( TX_TIMEOUT_VALUE );
                break;
           case 'H':
                // radfta ctrl.cls();
                debug("Starting hello exchange\r\n");
                gpsEnabled = false;
                fflush(stdout);
                app = APP_HELLO;
                Radio.Rx( RX_TIMEOUT_VALUE );
                Radio.Tx( TX_TIMEOUT_VALUE );
                break;                
            case 'C':
                // radfta  ctrl.cls();
                printf("Starting chat app\r\n");
                //printf("-chat-> ");
                fflush(stdout);
                ackRcvd = true;
                app = APP_CHAT;
                Radio.Rx( RX_TIMEOUT_VALUE );
                //radf Radio.Tx( TX_TIMEOUT_VALUE );
                break;    
            default:
                debug("Unsupported command received\r\n");
                break;     
          }
    } else if (pcbuf[0] == 'f' && pcbuf[1] == 'r' && pcbuf[2] == 'f') {
            if (pcbuf[3] >= '0' && pcbuf[3] <= '9') {
                float MHz;
                sscanf(pcbuf+3, "%f", &MHz);
                MHz *= 1000000;
                // printf("MHz:%f\r\n", MHz);
                Frequency = (MHz);
            }
            Radio.SetChannel( Frequency ); 
            configRxTx();
            printf("Channel: %.1f MHz\r\n", Radio.GetChannel());

    } else if (pcbuf[0] == 'o' && pcbuf[1] == 'p') {
            if (pcbuf[2] >= '0' && pcbuf[2] <= '9') {
                sscanf(pcbuf+2, "%d", &TxPower);
                //printf("setting tx power to %d\r\n", TxPower);
                configRxTx();
                 
            }
            print_power(); printf("\r\n");
            //printf("OutputPower: %d\r\n",  ( uint8_t )( ( uint16_t )( Radio.Read(REG_PACONFIG) - 1 ) & 0x0F ));
            
    } else if (pcbuf[0] == 'b' && pcbuf[1] == 'w') {
            
               if (pcbuf[2] >= '0' && pcbuf[2] <= '2') {
                    Radio.Standby();
                    sscanf(&pcbuf[2], "%d", &Bandwidth);
                    switch (Bandwidth) {
                        case 0:
                            printf("setting bandwidth to 125KHz\r\n");
                            break;
                        case 1:
                            printf("setting bandwidth to 250KHz\r\n");
                            break;   
                        case 2:
                            printf("setting bandwidth to 500KHz\r\n");
                            break;    
                    }
                    configRxTx();
                }
                print_bandwidth(); printf("\r\n");
                
    } else if (pcbuf[0] == 's' && pcbuf[1] == 'f' ) {
            if (pcbuf[2] >= '0' && pcbuf[2] <= '9') {
                sscanf(pcbuf+2, "%d", &SpreadingFactor);
                configRxTx();
            }
            printf("Spreading Factor: %d\r\n",SpreadingFactor);
            
    } else if (pcbuf[0] == 'c' && pcbuf[1] == 'r' ) {
            if (pcbuf[2] >= '0' && pcbuf[2] <= '9')
            {
                sscanf(pcbuf+2, "%d", &CodingRate);
                configRxTx();
            }
              
            print_cr();printf("\r\n");

    } 
#if 0    
    else
        debug("Unsupported command\r\n");
#endif        
    
    if (app  == APP_CONSOLE)
    {
        printf("> ");
        fflush(stdout);
    }
        
}        

void check_rx_chat()
{      
    //wait(1);
    switch( State )
    {
        case RX:
               
                if( BufferSize > 0 )
                {
                        if( strncmp( ( const char* )BufferRx, "ACK", 3 ) != 0 )
                        {
                            // received msg is not an ACK, so ACK it
                            //red = !red;
                            printf("\b\b\b\b\b\b\b\bchat received msg: %s \r\n", BufferRx );
                            printf("-chat-> ");
                            fflush(stdout);
                            memcpy( BufferTx, "ACK", 3 );
                            Radio.Send( BufferTx, 3 );
                        }
                        else
                        {   
                            ackRcvd = true;
                            // printf("got an ack\r\n");
                        }
              
                }
            Radio.Rx( TX_TIMEOUT_VALUE );    
            State = LOWPOWER;
            break;
        case TX:    
         //   red = !red;
            // debug("tx in chat mode\r\n"); 
            ackRcvd = false;
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case RX_TIMEOUT:
            static int retryCount=1;
            if (ackRcvd == false)
            {
                if (retryCount <= 4)
                {
                    Radio.Send( BufferTx, txLen );
                    ++retryCount;
                }
                else
                {
                    retryCount = 1;
                    printf("\r\nLast message (%s) was not acked", BufferTx);
                    fflush(stdout);    
                    ackRcvd = true;
                }
            }
            Radio.Rx( RX_TIMEOUT_VALUE );  
                                                       
            State = LOWPOWER;
            break;
        case RX_ERROR:
            debug("rx error in chat mode\r\n");
            State = LOWPOWER;
            break;
        case TX_TIMEOUT:
            //debug("tx timeout in chat mode\r\n");
            Radio.Rx( RX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            wait_ms (5);
            break;
        default:
            // debug("state is set to low power\r\n");
            State = LOWPOWER;
            break;
    }    
 
}