#include "mbed.h"
#include "main.h"
#ifndef STANDALONE
#include "lcdadafruit.h"
#include "GPS.h"
#endif
#include "sx1276-hal.h"
#include "debug.h"
#include "serial_api.h"
#include "datetime.h"
#include "time.h"
#include <string>


#define USE_MODEM_LORA  1
#define RF_FREQUENCY                                    868000000 // Hz
//#define RF_FREQUENCY                                    880030000 
//#define RF_FREQUENCY                                      914000000.0 // Hz
//#define RF_FREQUENCY                                    413000000.0 // Hz


//#define BUFFER_SIZE                                     64        // Define the payload size here

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
//DigitalOut led(LED2);
DigitalOut led(LED_RED);
#else
DigitalOut led(LED1);
#endif
Serial pc(USBTX, USBRX);

float Frequency = RF_FREQUENCY;
float distance = -1;
float r_latitude = 0;
float r_latitude_last = 0;
float r_longitude = 0;
float r_longitude_last = 0;
int TxPower = TX_OUTPUT_POWER;
int Bandwidth = LORA_BANDWIDTH;
int SpreadingFactor = LORA_SPREADING_FACTOR;
int CodingRate = LORA_CODINGRATE;
struct tm Clock;

/*
 *  Global variables declarations
 */
typedef RadioState States_t;
volatile States_t State = LOWPOWER;

//SX1276MB1xAS Radio( OnTxDone, OnTxTimeout, OnRxDone, OnRxTimeout, OnRxError, NULL, OnCadDone );
SX1276MB1xAS Radio( OnTxDone, OnTxTimeout, OnRxDone, OnRxTimeout, OnRxError, NULL, NULL );
// for hand wired I2C cI2C(PTC9, PTC8); 
I2C cI2C(PTC9, PTC8); 
// for stacked shield I2C cI2C(PTC2, PTC1); 
//I2C cI2C(PTC2, PTC1);
#ifndef STANDALONE
LCDadafruit cLCD(cI2C);
GPS gpsd(PTE0,PTE1);
#endif
  
// for other board GPS gpsd(PTE20, PTE21);

uint8_t PingMsg[256];
uint8_t PongMsg[256];
uint8_t HelloMsg[256];
char pcbuf[PCBUF_SIZE];
uint16_t BufferSize = BUFFER_SIZE;
uint8_t BufferTx[BUFFER_SIZE];
uint8_t BufferRx[BUFFER_SIZE];
int16_t RssiValue = 0.0;
int8_t SnrValue = 0.0;
int txLen = 0;
int pkt_count = 0;
int max_pkts = 20;
int pkt_data[20];
int per = 0;
int tx_rate_us = 1000000;  // 1 second
app_e app = APP_NONE;
bool isMaster = true;
bool AlwaysMaster = false;
bool AlwaysSlave = false;
bool ackRcvd = true;
bool rxTimeout = false;
bool gpsEnabled = true;
InterruptIn PPS(PTD7); //pps IRQ
DigitalOut RXin(PTD6);
Ticker usec_tick;
 
void tx_pkt() {
    led = !led;

     BufferSize=strlen((char *)BufferTx);
     #if 1    
  //   printf("Buffersize = %d\r\n",BufferSize);
   //  Radio.Send( BufferTx, BufferSize );
     Radio.Rx( RX_TIMEOUT_VALUE / 1  );
#else
       // printf("calling start cat\r\n");
    //    Radio.Send( BufferTx, BufferSize );
   //     Radio.Rx( RX_TIMEOUT_VALUE / 1  );
      //  Radio.StartCad();
#endif
}
  
void ppsSync()
{
    static int pps_count=0;
 
    ++pps_count;
    if (pps_count == 1)
    {
        // detach the timer
        usec_tick.detach();
       
        wait_ms(500);
        usec_tick.attach_us(&tx_pkt, tx_rate_us);
     //   printf("call attach\r\n");
    }
    else
    {
        if (pps_count > 10)
        {
            pps_count = 0;
        }
    }
    
    //printf("got a pps\r\n");
    //ShowDateTime();
   
}
int main()
{
  
    int i;
    RXin=0;
    Timer refresh_Timer; //sets up a timer for use in loop; how often do we print GPS info?
    const int refresh_Time = 1000; //refresh time in ms
    bool gpsFix=false;
  
    pc.baud(9600);
    cI2C.frequency(400000);    // I2C can handle two different frequencies - switch to high speed if asked
    #ifndef STANDALONE
    gps_setup();
    cLCD.clear();
    cLCD.home();
    cLCD.setCursor(0,0);
    cLCD.printf("   HOMER   ");
    cLCD.setCursor(0,1);
    cLCD.printf("   DOH!    ");   
    #endif
 
    rxTimeout = false;
    // PTD1 (the SCK pin for the one SPI interface onboard the KL25z) is actually an output to the Blue LED. 
    // the lora shield drives SCK, which turns on the blue led.  use PTC5 instead of the default PTD1 for SCK
     
    if (RADIO_INSTALLED)
        debug( "    SX1276 Test Applications \r\n\n" );
    led = 1;  
    
    // init pkt_data array to 0
    for (i=0;i<pkt_count;i++)
        pkt_data[pkt_count]=0;

    // verify the connection with the board
    if (RADIO_INSTALLED)
    {

        while( Radio.Read( REG_VERSION ) == 0x00  )
        {
            debug( "Radio could not be detected!\r\n", NULL );
            wait( 1 );
        }
  
   
        debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1276MB1LAS ) ) , "> Board Type: SX1276MB1LAS < \r\n" );
        debug_if( ( DEBUG_MESSAGE & ( Radio.DetectBoardType( ) == SX1276MB1MAS ) ) , "> Board Type: SX1276MB1MAS < \r\n" );
        Radio.SetChannel( Frequency ); 
    //    Radio.StartCad();
    //    printf("start cad\r\n");
        debug_if( !LORA_FHSS_ENABLED, "> LORA Mode < \r\n");
        configRxTx();
    
        //print_status();
        debug_if( DEBUG_MESSAGE, "Starting Application loop\r\n" ); 
        wait(1);
    
     // led = 0;
 
        strcat((char *)PingMsg,"PING");
        strcat((char *)PongMsg,"PONG");
        strcat((char *)HelloMsg,"HELLO_7");
         
        Radio.Rx( RX_TIMEOUT_VALUE );
        Radio.Tx( TX_TIMEOUT_VALUE );
         
        app = APP_HELLO;
        //app = APP_CHAT;
    }
    else
    {
        app = APP_GPS;
        pc.printf("Starting GPS App\r\n");
    }
    
    refresh_Timer.start();  //starts the clock on the timer used for gps refreshes
  //  usec_tick.attach_us(&tx_pkt, tx_rate_us);  // attach a timer to periodically call tx.  this timer will be restarted in ppsSync to synronize timer accross systems
  //  PPS.rise(&ppsSync);  // call ppsSync when the PPS irq is detected
  //  printf("start cad 2\r\n");
 //   Radio.StartCad();
    
    while( 1 )
    {
#ifndef STANDALONE        
        //printf("call check \r\n");
        check_gps();
        if (refresh_Timer.read_ms() >= refresh_Time) 
        {
            //printf("reset timer popped\r\n");
            if (gpsd.fix) 
            {
                // got a gps fix
                if (gpsFix == false)
                {
                    // first time fix obtained
                    gpsFix = true;
                    // set the rtc with the latest gps time

                    pc.printf("GPS fix obtained on %02d/%02d/20%02d_%02d:%02d:%02d (UTC)\r\n",gpsd.month,gpsd.day,gpsd.year,gpsd.hour,gpsd.minute,gpsd.seconds);
                    // update rtc with the latest gps time stamp
                    SetDateTime(gpsd.year+2000,
                        gpsd.month,
                        gpsd.day,
                        gpsd.hour,
                        gpsd.minute,
                        gpsd.seconds);
                }
#if 0                
                else
                {
                    printf("radfta - ");
                    ShowDateTime();
              //    pc.printf("GPS %02d/%02d/20%02d_%02d:%02d:%02d (UTC)\r\n",gpsd.month,gpsd.day,gpsd.year,gpsd.hour,gpsd.minute,gpsd.seconds);
                }
#endif
  
            }
            else
            {
                gpsFix = false;
                cLCD.setCursor(0,1);
                cLCD.printf("No GPS. per:%d      ",per);
                //pc.printf("Waiting for GPS FIX\r\n");
              
            }
          
            refresh_Timer.reset();    
        }
      
#endif      
        switch (app) {
            case APP_PING:
                start_ping_pong();
                break;
            case APP_CHAT:
                console_chat();
                break;
            case APP_GPS:
#ifndef STANDALONE
                check_gps();
#endif          
                break;    
            case APP_HELLO:
                wait(1);
                start_hello();
                break;
            case APP_CONSOLE:
                // printf("-chat-> x");
                fflush(stdout);    
                console();
                break;
            default:
                printf("unknown app %d\r\n", app);
                break;    
        } // ...switch (app)
      
    }
   
}
