#include "mbed.h"
#include "sx1276-hal.h"
#include "main.h"
#include "debug.h"
#include "serial_api.h"
#ifndef STANDALONE
#include "GPS.h"
#endif
#include <math.h>


void start_hello(void)
{
    int len = get_kbd_str(pcbuf, PCBUF_SIZE);
    //printf("in start gps/hello len=%d\r\n",len);
    if (len < 0) {
        fflush(stdout);
        Radio.Rx( RX_TIMEOUT_VALUE );
        Radio.Tx( TX_TIMEOUT_VALUE );
        Radio.Sleep( );
        if (gpsEnabled)
            debug("GPS exchange ended\r\n");
        else
            debug("Hello exchange ended\r\n");    
        app = APP_CONSOLE;
        print_help();
        printf("> ");
        fflush(stdout);
        return;
    }
    else
    {   
       Radio.Rx( RX_TIMEOUT_VALUE / 3  );
       hello();
    }
}

void hello(void)
{
 
    // srand ( randomSeed() );
    // generate a random wait time
    int mywait = ((rand()%2 +1));
   // int mywait = 3;
    int i=0;
    int rcvd=0;
    int lost=0;
     
    // check_gps();
    for (i=0;i<max_pkts;i++)
    {
        
        if (pkt_data[i]==1)
        {
            //printf("rcvd, pkt count=%d\r\n",i);
            rcvd++;
        }
        else if (pkt_data[i] == 2)
        {
            //printf("lose, pkt count=%d\r\n",i);
            lost++;
        }
     
    }
    if ((rcvd + lost) > 0)
    {
        per = 100 - (rcvd*100 / (rcvd + lost));
        //printf("rcvd = %d, lost = %d per = %d\r\n",rcvd, lost, per);
    }
    else 
        per = 0;

 
    switch( State )
    {
  
        case RX_TIMEOUT:

            printf("rx timeout in gps/hello loop. ");
            printf("per=%d\r\n", per);
            r_latitude = 0;
            r_longitude = 0;
            // printf("rcv - rssi = %d snr = %d msg=%s\r\n", RssiValue, SnrValue, BufferRx);
            #ifndef STANDALONE
            cLCD.setCursor(0,0);
            cLCD.printf("RI:NA SR:NA      ");
            #endif
        case RX:
             
            if( BufferSize > 0 )
            {
                RXin = !RXin;
                if( strncmp( ( const char* )BufferRx, ( const char* )HelloMsg, 5 ) == 0 )
                {
                    // radfta led = !led;     
                    printf("rcv - rssi = %d snr = %d msg=%s ", RssiValue, SnrValue, BufferRx );
                    printf("per=%d\r\n", per);
                    #ifndef STANDALONE
                    cLCD.setCursor(0,0);
                    cLCD.printf("RI:%d SR:%d   ", RssiValue, SnrValue);
                    #endif
                }
                #ifndef STANDALONE
                else
                {

                  if(sscanf((char *)BufferRx, "GP,%f,%f", &r_latitude, &r_longitude ) >= 1) 
                  {    
                    r_latitude_last = r_latitude;     
                    r_longitude_last = r_longitude;           
                    // radfta led = !led;     
                    printf("rssi=%d snr=%d rlat=%0.5f rlon=%0.5f llat=%0.5f llon=%0.5f dst=%0.0fm ", RssiValue, SnrValue, r_latitude, r_longitude, gpsd.lat_deg, gpsd.lon_deg, distance);
                    printf("per=%d\r\n", per);
                    cLCD.setCursor(0,0);
                    cLCD.printf("RI:%d SR:%d    ", RssiValue,SnrValue);
                    //printf("Msg received - Lat: %0.4f Lon: %0.4f\r\n", latitude, longitude);
                  }
                  else
                    printf("strange received message: %s\r\n", BufferRx);
           
                }
                #else
                  if(sscanf((char *)BufferRx, "GP,%f,%f", &r_latitude, &r_longitude ) >= 1) 
                    printf("rssi=%d \tsnr=%d \tper=%d  \tmsg=%s\r\n", RssiValue, SnrValue, per, BufferRx);
                #endif
            }
       case RX_ERROR:
#ifndef STANDALONE         
            if (gpsEnabled)
                sprintf((char *)BufferTx, "GP,%4.5f,%4.5f", gpsd.lat_deg, gpsd.lon_deg);
            else
#endif            
                strcpy( ( char* )BufferTx, ( char* )HelloMsg );
#if 1
            BufferSize=strlen((char *)BufferTx);
            //printf("Sending new buffer\r\n");
            Radio.Send( BufferTx, BufferSize );
            State = LOWPOWER;
#else            
            State = CAD;
#endif            

            break;
        case TX:    
            // printf("tx state\r\n");
            // wait_ms (10);
            Radio.Rx( RX_TIMEOUT_VALUE / mywait  );
            State = LOWPOWER;
            break;
         case TX_TIMEOUT:
            debug("tx timeout\r\n");
            Radio.Tx( TX_TIMEOUT_VALUE );
            State = LOWPOWER;
            break;
        case LOWPOWER:
            //printf("in wait\r\n");
            //wait_ms (1);
            //wait_us(200);
#ifndef STANDALONE
            check_gps();
#endif      
            break;
        case CAD:
             printf("in cad\r\n");
            //State = LOWPOWER;
            break;
        default:
             //debug("state is set to CAD\r\n");
            State = LOWPOWER;
            break;
    }    
}
