#include "mbed.h"
#include "KL25Z_RTC.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);

// Init the RTC module.
KL25Z_RTC rtc(NULL);

// Hardware warning!!!!! 
// Hardware warning!!!!! 
// Hardware warning!!!!! 
// Hardware warning!!!!! 
// To enable the rtc on the kl25z, a jumper must be placed between PTC1 (J10, pin 12) and PTC3 (J1, pin 3) and the resistor R24 must
// be removed from the board: https://developer.mbed.org/questions/5706/Which-one-is-R24/
// These changes allow for the application of an internal 32 khz reference signal on the RTC clock in pin (PTC1).  Without both of 
// these hardware mods, the real time clock will not increment
 
void set_CLKOUT32k(void){ 
    MCG->C1 |= MCG_C1_IRCLKEN_MASK; // Enable the internal reference clock. MCGIRCLK is active.
    MCG->C2 &= ~(MCG_C2_IRCS_MASK); // Select the slow internal reference clock source.
    SIM->SOPT1 &= ~SIM_SOPT1_OSC32KSEL_MASK; 
    //SIM->SOPT1 |= SIM_SOPT1_OSC32KSEL(0x2); // Select 32 KHz clock source as RTC_CLKIN
    SIM->SOPT2 |= SIM_SOPT2_CLKOUTSEL(0x4); // Set PTC3 as CLKOUT pin for MCGIRCLK
    SIM->SCGC5|=SIM_SCGC5_PORTC_MASK;       //Enable Clock to Port C 
    PORTC->PCR[3] |= (PORT_PCR_MUX(0x5)); // Select the MCGIRCLK clock to output on the CLKOUT pin.
}
 
void SetDateTime
(int           year = 2015
,int           mon = 5
,int           day = 26
,int           hour = 10
,int           min = 0
,int           sec = 0
)
{
    struct     tm Clock;
    Clock.tm_year = year - 1900;
    Clock.tm_mon  = mon;
    Clock.tm_mday = day;
    Clock.tm_hour = hour;
    Clock.tm_min  = min;
    Clock.tm_sec  = sec;
    time_t epoch = mktime(&Clock);
    if (epoch == (time_t) -1) {
        error("Error in clock setting\r\n");        
    }
    set_time(epoch);
}   

void ShowDateTime()
{
    char       str[32];
    time_t     seconds = time(NULL);
    struct tm *tminfo = localtime(&seconds);
 
    strftime(str, 32, "%F,%T", tminfo);
    printf("RTC: %s\r\n", str);
}
 
int main() {
    
    pc.baud( 9600);
    set_CLKOUT32k();
    rtc.RTC_Start();
 
    SetDateTime();
    while(1) 
    {
     
        ShowDateTime();
        myled=0;
        wait_ms(200);
        myled=1;
        wait_ms(800);

    }
}

 