/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    ( C )2014 Semtech

Description: Contains the callbacks for the IRQs and any application related details

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __MAIN_H__
#define __MAIN_H__
#define STANDALONE 1
#ifndef STANDALONE
#include "lcdadafruit.h"
#include "GPS.h"
#endif
#include "enums.h"
#include "typedefs.h"

/*
 * Callback functions prototypes
 */
/*!
 * @brief Function to be executed on Radio Tx Done event
 */
void OnTxDone( void );

/*!
 * @brief Function to be executed on Radio Rx Done event
 */
void OnRxDone( uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr );

/*!
 * @brief Function executed on Radio Tx Timeout event
 */
void OnTxTimeout( void );

/*!
 * @brief Function executed on Radio Rx Timeout event
 */
void OnRxTimeout( void );

/*!
 * @brief Function executed on Radio Rx Error event
 */
void OnRxError( void );

/*!
 * @brief Function executed on Radio Fhss Change Channel event
 */
void OnFhssChangeChannel( uint8_t channelIndex );

/*!
 * @brief Function executed on CAD Done event
 */
void OnCadDone( bool activity );

char* itoa(int val, int base);
unsigned int randomSeed(void);
void start_ping_pong(void);
void ping_pong(void);
void start_hello(void);
void hello(void);
int get_kbd_str(char* buf, int size);
void console_chat();
void console();
void check_rx_chat();
void configRxTx();
void print_status();
void print_help();
void print_bandwidth();
void print_cr();
void print_power();
void gps_setup(void);
int check_gps(void);

/*
 *  Global variables declarations
 */
extern Serial pc;
//extern char pcbuf[];

#define RX_TIMEOUT_VALUE                                5000000   // in us
#define TX_TIMEOUT_VALUE                                4000000   // in us
#define BUFFER_SIZE                                     256        // Define the payload size here
#define RADIO_INSTALLED                                 true
/* Set this flag to '1' to display debug messages on the console */
#define DEBUG_MESSAGE   1
#define TX_OUTPUT_POWER                                 20        // 14 dBm
#define LORA_BANDWIDTH                                  0         // [0: 125 kHz,
                                                                  //  1: 250 kHz,
                                                                  //  2: 500 kHz,
                                                                  //  3: Reserved]
// #define LORA_SPREADING_FACTOR                        7         // [SF7..SF12]
#define LORA_SPREADING_FACTOR                           12        // [SF7..SF12]
// #define LORA_CODINGRATE                              1         // [1: 4/5,
#define LORA_CODINGRATE                                 2         // [1: 4/5,
                                                                  //  2: 4/6,
                                                                  //  3: 4/7,
                                                                  //  4: 4/8]
#define LORA_PREAMBLE_LENGTH                            8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                             5         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                      false
#define LORA_FHSS_ENABLED                               false  
#define LORA_NB_SYMB_HOP                                4     
#define LORA_IQ_INVERSION_ON                            false
#define LORA_CRC_ENABLED                                true

#if( defined ( TARGET_KL25Z ) || defined ( TARGET_LPC11U6X ) )
extern DigitalOut led;
#else
extern DigitalOut led;
#endif
 
typedef RadioState States_t;
#ifndef STANDALONE
extern LCDadafruit cLCD;
extern GPS gpsd;
#endif
extern volatile States_t State;
extern SX1276MB1xAS Radio;
extern uint8_t PingMsg[];
extern uint8_t PongMsg[];
extern uint8_t HelloMsg[];
extern uint16_t BufferSize;
extern uint8_t BufferTx[];
extern uint8_t BufferRx[];
// radfta extern vt100 ctrl;
extern float Frequency;
extern float distance;
extern float r_latitude;
extern float r_latitude_last;
extern float r_longitude_last;
extern float r_longitude;
extern int TxPower;
extern int Bandwidth;
extern int SpreadingFactor;
extern int CodingRate;
extern int pkt_count;
extern int pkt_data[];
extern int max_pkts;
extern int per;
extern bool isMaster;
extern bool AlwaysMaster;
extern bool AlwaysSlave;
extern bool rxTimeout;
extern char pcbuf[];
extern bool ackRcvd;
extern bool gpsEnabled;
extern int txLen;
extern int16_t RssiValue;
extern int8_t SnrValue;
extern DigitalOut RXin;
#define PCBUF_SIZE 64
#define PI 3.14159265

typedef enum {
    APP_NONE = 0,
    APP_PING,
    APP_CHAT,
    APP_HELLO,
    APP_CONSOLE,
    APP_GPS
} app_e;

extern app_e app;

#endif // __MAIN_H__