#include "mbed.h"
#include "datos.h"
#include "arm_math.h" //utilizar funcion de q15 a float32 para optimizar la funcion a 22ums

Timer timer;
float resultado;
float resultado2;
int tiempo;

float calcularRMS(int16_t *datos, int longitud); //definicion del tipo de variable que devuelve la funcion
float calcularRMS2(int16_t *datos, int longitud); //definicion del tipo de variable que devuelve la funcion


int main()
{

    timer.reset();
    timer.start();
    resultado=calcularRMS(datos, 500);
    timer.stop();
    printf("****El valor Vrms es %f calculado en %d us ****\n\r",resultado,timer.read_us());
    
    timer.reset();
    timer.start();
    resultado2=calcularRMS2(datos, 500);
    timer.stop();
    printf("****El valor Vrms2 es %f calculado en %d us ****\n\r",resultado2,timer.read_us());
    
}


float calcularRMS(int16_t *datos, int longitud)  // definicion de los estamentos de la funcion
{
    float32_t k=1.007080078125000e-04;
    int64_t producto=0;
    
    for (int n=0; n<longitud; n++) {
        producto+=datos[n]*datos[n];
    }
    return sqrt((float(producto)/longitud))*k;
    
}


float calcularRMS2(int16_t *datos, int longitud)  // definicion de los estamentos de la funcion
{
    
    q15_t resultado2;
    float resultado2aux;
    arm_rms_q15((q15_t *)datos ,   longitud,   &resultado2);
    arm_q15_to_float(&resultado2,&resultado2aux,1);
    return resultado2aux*3.3f;
}


