#include "mbed.h"
#include "arm_math.h"
#include "TextLCD.h"

#include "datos_muestreo_corriente.h"
#include "datos_muestreo_voltaje.h"

Ticker timerCapturaMuestreo;
Ticker timerMostrar;

Serial pc(USBTX, USBRX); // tx, rx

#define longitud 100

float Vrms;
float Irms;
float P;
float Q;
float S;
float FDP;

//BUFFERS DE VOLTAJE
float bufferA[longitud];
float bufferB[longitud];

//BUFFERS DE INTENSIDAD
float bufferC [longitud];
float bufferD [longitud];

//
int contador=0 ;
int nbuffer=1 ;
int bufferlleno ;
int mostrarDato=1 ;
float rms ;
float Vpp ;

//punteros
int16_t *pA ;
int16_t *pB ;

void muestreo () //hay que programar que se ejecute la funcion cada X tiempo (siendo X el tiempo de muestreo)
{
    if (nbuffer==1) { //si nbuffer=1 entonces se guardan los datos en el buffer A, else buffer B
        bufferA[contador]=muestreo_voltaje [contador]*1.971327996035224e+02-3.252691193458119e+02 ; //VOLTAJE
        bufferC[contador]=muestreo_intensidad [contador]*7.453035901834493-12.297509238026914 ;  //INTENSIDAD
        contador=contador+1 ;
        if (contador==longitud) {
            nbuffer=0 ;
            contador=0 ;
            bufferlleno=1;
        }
    } else {
        bufferB[contador]=muestreo_voltaje [contador]*1.971327996035224e+02-3.252691193458119e+02; //VOLTAJE ;
        bufferD[contador]=muestreo_intensidad [contador]*7.453035901834493-12.297509238026914 ;  //INTENSIDAD ;
        contador=contador+1 ;
        if (contador==longitud) {
            nbuffer=1 ;
            contador=0 ;
            bufferlleno=1;
        }
    }
}


// vamos a programar un boton como una entrada digital que nos permita seleccionar
// el tipo de dato que queremos visualizar en la lcd

//primero definimos como digitales las entradas en las que estarán los pulsadores

InterruptIn pulsador1(PC_13);
InterruptIn pulsador2 (D2);

void botonUP ()
{
        mostrarDato+=1;
        if (mostrarDato==9) {
            mostrarDato=1;
        } 
}

void botonDOWN ()
{
            mostrarDato-=1;
            if (mostrarDato==0) {
                mostrarDato=8;
            }
}

void mostrar ()
{
}


float calcularRMS(float *datos, int N); //definicion del tipo de variable que devuelve la funcion
float calcularRMS(float *datos, int N)   // definicion de los estamentos de la funcion
{
    float32_t producto=0;
    
    for (int n=0; n<longitud; n++) {
        producto+=datos[n]*datos[n];
    }
    return sqrt((float(producto)/longitud));
    
}

float calcular_potencia_activa(float *datos1,float *datos2, int N);
float calcular_potencia_activa(float *datos1,float *datos2, int N)
{
    float sumatorio=0;
    for (int16_t n=0; n<N; n++)
    {
        sumatorio+=datos1[n]*datos2[n];
    }
    return sumatorio/N;
}
    
float calcular_potencia_reactiva_MAL(float Vrms,float Irms,float P,float S);
float calcular_potencia_reactiva_MAL(float Vrms,float Irms,float P,float S)    
{
    float Q=sqrt(S-P);
    return Q;
}
    
    
float calcular_potencia_aparente(float Vrms,float Irms);
float calcular_potencia_aparente(float Vrms,float Irms)
{
    float S=Vrms*Irms;
    return S;
}
    
    
float calcular_potencia_reactiva(float *datos1,float *datos2, int N);
float calcular_potencia_reactiva(float *datos1,float *datos2, int N)
{
    return 0;
}

float fdp (float S,float P);
float fdp (float S,float P)
{
    float fdp=P/S;
    return fdp;
}


int main()
{
    pulsador1.rise(&botonUP);
    pulsador2.rise(&botonDOWN);
    timerCapturaMuestreo.attach_us(&muestreo,200);
    timerMostrar.attach(&mostrar,1.0);
    while(1) {
        wait (4);
        if (bufferlleno==1) {
            bufferlleno=0;
            if (nbuffer==0) 
            {
                float Vrms=calcularRMS(bufferA,longitud);
                pc.printf("voltaje:\n%f",Vrms,"\t //");
                float Irms=calcularRMS(bufferC,longitud);
                pc.printf("intensidad:\n%f",Irms,"\t //");
                float P=calcular_potencia_activa(bufferA,bufferC,longitud);  
                pc.printf("potencia activa:\n%f",P,"\t //");  
                float S=calcular_potencia_aparente(Vrms,Irms);
                pc.printf("potencia aparente:\n%f",S,"\t //");
                float Q=calcular_potencia_reactiva_MAL(Vrms,Irms,P,S);
                pc.printf("potencia reactiva:\n%f",Q,"\t //");
                float FDP=fdp(S,P);
                pc.printf("FDP:\n%f",FDP,"\t //");
            }
             
            else
            {
                float Vrms=calcularRMS(bufferB,longitud);
                pc.printf("voltaje:\n%f",Vrms,"\t //");
                float Irms=calcularRMS(bufferD,longitud);
                pc.printf("intensidad:\n%f",Irms,"\t //");
                float P=calcular_potencia_activa(bufferB,bufferD,longitud);
                pc.printf("potencia activa:\n%f",P,"\t //");
                float S=calcular_potencia_aparente(Vrms,Irms);
                pc.printf("potencia aparente:\n%f",S,"\t //");
                float Q=calcular_potencia_reactiva_MAL(Vrms,Irms,P,S);
                pc.printf("potencia reactiva:\n%f",Q,"\t //");
                float FDP=fdp(S,P);
                pc.printf("FDP:\n%f",FDP,"\t //");
            }
            }        
    }
}


