#ifndef MBED_IC_MU_H
#define MBED_IC_MU_H
 
#include "mbed.h"
 
class iC_MU {
public:
    /**
     * Constructor.
     */
    iC_MU(PinName mosi, PinName miso, PinName sclk, PinName cs);
    
    /**
     * Request the device status
     *
     * returns the current status
     */
    int RequestSTATUS();
    
    /**
     * Reads the specified reg
     *
     * @returns the reg contents
     */
    int ReadREGISTER(char reg);
    
    /**
     * Writes to the specified reg.
     *
     * @returns the device reply
     */
    int WriteREGISTER(char reg, char data);
    
    /**
     * Send the activate cmd
     *
     * @returns the device reply
     */
    int ACTIVATE(char reg);
    
    /**
     * Read the current position
     *
     * @returns the position as an int
     */
    int ReadPOSITION();
    
    /**
     * Sets the iC_MU up as the eval board was sniffed.
     * Not sure we need to do this???
     *
     * @returns 1
     */
    int initalise();
  
private:  
    SPI _spi;
    DigitalOut _ncs;
};
 
#endif