#include "mbed.h"
#include "iC_MU.h"

iC_MU::iC_MU(PinName MOSI, PinName MISO, PinName CLK, PinName nCS) : _spi(MOSI, MISO, CLK), _ncs(nCS) {

    // Set up the SPI port...
    _spi.frequency(5000000);           // 10MHz is the fastest mbed frequency supported by the iC_MU
    _spi.format(16,3);                  // Set for mode 3 16_bits
    
    // To start with I need the chip select high and wait 1ms after powering up
    _ncs = 1;
    wait(0.001);
}

int iC_MU::RequestSTATUS()
{
    int reply = 0;

    _spi.format(8,3);               // Set to 8_bit mode 3
    _ncs = 0;                       // Bring nCS low to start write
    reply = _spi.write(0xAD);       // Write REGISTER status/data cmd
    reply = reply << 8;             // bit shift reply
    reply += _spi.write(0x00);      // Send dummy byte
    reply = reply << 8;             // bit shift reply
    reply += _spi.write(0x00);      // Send dummy byte
    _ncs = 1;                       // Set nCS high to send write
    _spi.format(16,3);              // Set back to 16_bit mode 3
    return(reply);
}

int iC_MU::ReadREGISTER(char reg)
{
    int reply = 0;
    int msg = 0x9700 + reg;

    _ncs = 0;                       // Bring nCS low to start write
    reply = _spi.write(msg);        // Write ACTIVATE cmd
    _ncs = 1;                       // Set nCS high to send write
    return(reply);
}

int iC_MU::WriteREGISTER(char reg, char data)
{
    int reply = 0;

    _spi.format(8,3);               // Set to 8_bit mode 3
    _ncs = 0;                       // Bring nCS low to start write
    reply = _spi.write(0xD2);       // Write REGISTER status/data cmd
    reply = reply << 8;             // bit shift reply
    reply += _spi.write(reg);       // Send the register addres to be written to
    reply = reply << 8;             // bit shift reply
    reply += _spi.write(data);      // Send the data to be written
    _ncs = 1;                       // Set nCS high to send write
    _spi.format(16,3);              // Set back to 16_bit mode 3
    return(reply);
}

int iC_MU::ACTIVATE(char reg)
{
    int reply = 0;
    int msg = 0xB000 + reg;

    _ncs = 0;                       // Bring nCS low to start write
    reply = _spi.write(msg);        // Write ACTIVATE cmd
    _ncs = 1;                       // Set nCS high to send write
    return(reply);
}

int iC_MU::ReadPOSITION()
{
    int reply = 0;

    _ncs = 0;                       // Bring nCS low to start write
    reply = _spi.write(0xA600);     // Write REGISTER status/data cmd
    reply = reply << 16;            // bit shift reply
    reply += _spi.write(0x0000);    // Send dummy byte
    _ncs = 1;                       // Set nCS high to send write

    // Shift around data
    reply = (reply & 0x00FFFFFF);   // Mask out top byte
    reply = reply >> 5;             // Cut off last nibble

    return(reply);
}