#include "mbed.h"

// For Testing

Serial pc(USBTX, USBRX);
DigitalIn MotorDir(p14);
AnalogIn AinTILT(p19);
AnalogIn AinPAN(p20);
PwmOut PanPWM(p21);
DigitalOut PanDir(p22);
PwmOut TiltPWM(p23);
DigitalOut TiltDir(p24);

int main() {
    
    float ADCdataPAN;
    float ADCdataTILT;
    int Dir;
    
    
    // Set up the Pan motor
    PanPWM.period_us(50);                // Set PWM to 20 kHz
    PanPWM = 1;                   // Start with motor static
    
    // Set up the Tilt motor
    TiltPWM.period_us(50);                // Set PWM to 20 kHz
    TiltPWM = 1;                   // Start with motor static
       
    pc.printf("ADC Data Values... \n\r");      
    
    while(1) {    
        
            
            ADCdataPAN=AinPAN;
            ADCdataTILT=AinTILT;
            Dir=!MotorDir;
            pc.printf("Pan pot value...\t%f\tTilt pot value...\t%f\n\r",ADCdataPAN,ADCdataTILT);
            PanDir = Dir;
            TiltDir = Dir;
            PanPWM = ADCdataPAN;
            TiltPWM = ADCdataTILT;
            
    }
}