#include "mbed.h"
#include "iC_MU.h"
#include "rtos.h"
#include "Classic_PID.h"

extern Serial pc;
extern Classic_PID PanVelocityPID;
extern Classic_PID TiltVelocityPID;
void Profile(void);
extern float Demand_Count_Rate;

extern bool joystick;
extern bool scoping;

extern float fade_tilt;
extern float fade_time;
extern float D;
extern float T;
extern float ts;
extern int DoMove;
extern float T_Position;
extern float T_Kp;
extern float Vff;
float setting;
extern float  Time;

extern float Joy_Zoom;

extern double drive;

// Returns the new set point entered via the keyboard
int ServiceKeyboard ()
{
    int key;                                            // The keypress by the user
    int value = 0;                                      // The variable to return

    key = pc.getc();                                    // Read the intial keypress

    switch (key)   {
// List keypresses used:
        case 'q':
            pc.printf("\n\r Toggle joystick = j \n\r Scope = s \n\r Fade = f \n\r Stop = c \n\r Set POS gains k, v, \n\r Set Vel Vff, kp: l, m \n\r Set fade time: t \n\r Save Shot = 1");
            pc.printf("\n\r Zoom Value (1-10) = z  \n\r Drive const speed = d");
            break;
// Save a shot position:
        case '1':

            fade_tilt = T_Position;
            pc.printf("\n\r Saving this postion as %f", fade_tilt);
            break;
// Switch Joystick Mode on and off
        case 'j':
            joystick = !joystick;
            if(joystick) {
                pc.printf("\n\r Under Joystick Control");
            } else {
                // Stop both axes
                //PanVelocityPID.setSetPoint(0);
                //TiltVelocityPID.setSetPoint(0);
                pc.printf("\n\r Under Full Profiler Control");
                pc.printf("\n\r");
            }
            break;
// Turn on Scope Tool:
        case 's':
            if (!scoping) {
                Time = 0;
                pc.printf("\n\r Time, Tilt_JoyStickDem, P_Error, T_Position, P, Motor_Speed, Demand_Speed");

                scoping = true;
            } else {
                scoping = false;
            }

            break;
// Calling A Fade:
        case 'f':
            if (DoMove == 0) {
                //fade_time = 15;
                Profile();
                pc.printf("\n\r Fade Distance: %f", D);
                pc.printf("\n\r Fade Time = %f,  Ramp segment =  %f",T, ts);
                DoMove = 1;
            }
            break;
            // We are going to set the fade time...
        case 't':
            pc.printf("\n\r New Fade Time: ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            fade_time = (setting);
            pc.printf("\n\r");
            break;
// Stop a fade
        case 'c':
            if (DoMove == 1) {
                pc.printf("\n\r Fade Stop");
                DoMove = 0;
                //TiltVelocityPID.setSetPoint(0);
            }
            break;
// Set Tilt Kp
        case 'k':
            pc.printf("\n\r New Tilt Pos Kp (Multiply by 100): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            T_Kp = (setting/100);
            //TiltVelocityPID.setKp(value);
            pc.printf("\n\r");
            break;
// We are going to set Pos Feedforward gain for tilt...
        case 'v':
            pc.printf("\n\r New Tilt Pos Vff (Multiply by 100): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            Vff = (setting/100);
            pc.printf("\n\r");
            break;
// We are going to set Kvelff gain for tilt...
        case 'l':
            pc.printf("\n\r New Tilt Velocity Vff (Multiply by 100): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            TiltVelocityPID.setKvelff(setting/100);
            pc.printf("\n\r");
            break;
// Set Tilt Velocity Kp
        case 'm':
            pc.printf("\n\r New Tilt Velocity Kp (Multiply by 100): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            TiltVelocityPID.setKp(setting/100);
            pc.printf("\n\r");
            break;
// Set Zoom level for Zoom proportional
        case 'z':
            pc.printf("\n\r Set Zoom Scalar Low 1-9 High): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            Joy_Zoom = (setting);
            pc.printf("\n\r");
            break;
            // We are going to set Pos Feedforward gain for tilt...
        case 'd':
            pc.printf("\n\r Drive const speed (Multiply by 100): ");
            key = pc.getc();
            do {
                key = pc.getc();                            // Wait for a keypress
                if(key >= '0' && key <= '9') {              // Check it is a number
                    value *= 10;                            // Index the old number
                    value += (key - '0');                   // Add on the new number
                    pc.printf("%c",key);                    // Display the new number
                }
            } while(key != 0x0D);
            setting = value;
            drive = setting;
            pc.printf("\n\r New Speed is = %f", (drive/100));
            break;
    }
    return(1);
}






